/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import co.crystaldev.alpinecore.util.Components;
import co.crystaldev.alpinecore.util.LocaleHelper;
import co.crystaldev.alpinecore.util.MappedMaterial;
import co.crystaldev.alpinecore.util.ReflectionHelper;
import co.crystaldev.alpinecore.util.RomanNumerals;
import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XItemFlag;
import com.cryptomorin.xseries.XMaterial;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemHelper {
    public static final MappedMaterial HELMETS = MappedMaterial.of(XMaterial.NETHERITE_HELMET, XMaterial.DIAMOND_HELMET, XMaterial.IRON_HELMET, XMaterial.CHAINMAIL_HELMET, XMaterial.GOLDEN_HELMET, XMaterial.LEATHER_HELMET, XMaterial.TURTLE_HELMET);
    public static final MappedMaterial CHESTPLATES = MappedMaterial.of(XMaterial.NETHERITE_CHESTPLATE, XMaterial.DIAMOND_CHESTPLATE, XMaterial.IRON_CHESTPLATE, XMaterial.CHAINMAIL_CHESTPLATE, XMaterial.GOLDEN_CHESTPLATE, XMaterial.LEATHER_CHESTPLATE);
    public static final MappedMaterial LEGGINGS = MappedMaterial.of(XMaterial.NETHERITE_LEGGINGS, XMaterial.DIAMOND_LEGGINGS, XMaterial.IRON_LEGGINGS, XMaterial.CHAINMAIL_LEGGINGS, XMaterial.GOLDEN_LEGGINGS, XMaterial.LEATHER_LEGGINGS);
    public static final MappedMaterial BOOTS = MappedMaterial.of(XMaterial.NETHERITE_BOOTS, XMaterial.DIAMOND_BOOTS, XMaterial.IRON_BOOTS, XMaterial.CHAINMAIL_BOOTS, XMaterial.GOLDEN_BOOTS, XMaterial.LEATHER_BOOTS);
    public static final MappedMaterial SWORDS = MappedMaterial.of(XMaterial.NETHERITE_SWORD, XMaterial.DIAMOND_SWORD, XMaterial.IRON_SWORD, XMaterial.GOLDEN_SWORD, XMaterial.STONE_SWORD, XMaterial.WOODEN_SWORD);
    public static final MappedMaterial AXES = MappedMaterial.of(XMaterial.NETHERITE_AXE, XMaterial.DIAMOND_AXE, XMaterial.IRON_AXE, XMaterial.GOLDEN_AXE, XMaterial.STONE_AXE, XMaterial.WOODEN_AXE);
    public static final MappedMaterial PICKAXES = MappedMaterial.of(XMaterial.NETHERITE_PICKAXE, XMaterial.DIAMOND_PICKAXE, XMaterial.IRON_PICKAXE, XMaterial.GOLDEN_PICKAXE, XMaterial.STONE_PICKAXE, XMaterial.WOODEN_PICKAXE);
    public static final MappedMaterial SHOVELS = MappedMaterial.of(XMaterial.NETHERITE_SHOVEL, XMaterial.DIAMOND_SHOVEL, XMaterial.IRON_SHOVEL, XMaterial.GOLDEN_SHOVEL, XMaterial.STONE_SHOVEL, XMaterial.WOODEN_SHOVEL);
    public static final MappedMaterial HOES = MappedMaterial.of(XMaterial.NETHERITE_HOE, XMaterial.DIAMOND_HOE, XMaterial.IRON_HOE, XMaterial.GOLDEN_HOE, XMaterial.STONE_HOE, XMaterial.WOODEN_HOE);
    public static final MappedMaterial ARMOR = MappedMaterial.builder().add(HELMETS).add(CHESTPLATES).add(LEGGINGS).add(BOOTS).build();
    public static final MappedMaterial TOOLS = MappedMaterial.builder().add(AXES).add(PICKAXES).add(SHOVELS).add(HOES).build();
    private static final Method ITEM_META_GET_DISPLAY_NAME = ReflectionHelper.findMethod(ItemMeta.class, "displayName", new Class[0]);
    private static final Method ITEM_META_SET_DISPLAY_NAME = ReflectionHelper.findMethod(ItemMeta.class, "displayName", Component.class);
    private static final Method ITEM_META_GET_LORE = ReflectionHelper.findMethod(ItemMeta.class, "lore", new Class[0]);
    private static final Method ITEM_META_SET_LORE = ReflectionHelper.findMethod(ItemMeta.class, "lore", List.class);

    public static boolean isMeleeWeapon(@NotNull ItemStack item) {
        return SWORDS.test(item) || AXES.test(item);
    }

    public static boolean isArmor(@NotNull ItemStack item) {
        return ARMOR.test(item);
    }

    public static boolean isTool(@NotNull ItemStack item) {
        return TOOLS.test(item);
    }

    @NotNull
    public static Component getDisplayName(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasDisplayName()) {
            return LocaleHelper.getTranslation(item);
        }
        if (ITEM_META_GET_DISPLAY_NAME != null) {
            return (Component)ReflectionHelper.invokeMethod(ITEM_META_GET_DISPLAY_NAME, meta, new Object[0]);
        }
        return LegacyComponentSerializer.legacySection().deserialize(meta.getDisplayName());
    }

    public static void setDisplayName(@NotNull ItemStack item, @NotNull Component name) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (ITEM_META_SET_DISPLAY_NAME != null) {
            ReflectionHelper.invokeMethod(ITEM_META_SET_DISPLAY_NAME, meta, name);
        } else {
            String serialized = LegacyComponentSerializer.legacySection().serialize(name);
            meta.setDisplayName(serialized);
        }
        item.setItemMeta(meta);
    }

    @NotNull
    public static List<Component> getLore(@NotNull ItemStack item) {
        return ItemHelper.getLore(item.getItemMeta());
    }

    @NotNull
    public static List<Component> getLore(@Nullable ItemMeta meta) {
        if (meta == null || !meta.hasLore()) {
            return Collections.emptyList();
        }
        if (ITEM_META_GET_LORE != null) {
            return (List)ReflectionHelper.invokeMethod(ITEM_META_GET_LORE, meta, new Object[0]);
        }
        return meta.getLore().stream().map(LegacyComponentSerializer.legacySection()::deserialize).collect(Collectors.toList());
    }

    @NotNull
    public static Component getJoinedLore(@NotNull ItemStack item, boolean appendNewLine) {
        List<Component> lore = ItemHelper.getLore(item);
        if (lore.isEmpty()) {
            return Component.empty();
        }
        if (appendNewLine) {
            return Components.joinNewLines(lore).append(Component.newline());
        }
        return Components.joinNewLines(lore);
    }

    @NotNull
    public static Component getJoinedLore(@NotNull ItemStack item) {
        List<Component> lore = ItemHelper.getLore(item);
        return lore.isEmpty() ? Component.empty() : Components.joinNewLines(lore);
    }

    public static void setLore(@NotNull ItemStack item, @NotNull List<Component> lore) {
        ItemMeta meta = item.getItemMeta();
        ItemHelper.setLore(meta, lore);
        item.setItemMeta(meta);
    }

    public static void setLore(@Nullable ItemMeta meta, @NotNull List<Component> lore) {
        List<Component> processedLore;
        if (meta == null) {
            return;
        }
        List<Component> list = processedLore = lore.isEmpty() ? lore : Components.split(Components.joinNewLines(lore), "\n");
        if (ITEM_META_SET_LORE != null) {
            ReflectionHelper.invokeMethod(ITEM_META_SET_LORE, meta, processedLore);
        } else {
            List serialized = processedLore.stream().map(LegacyComponentSerializer.legacySection()::serialize).collect(Collectors.toList());
            meta.setLore(serialized);
        }
    }

    @NotNull
    public static List<Component> getEnchantments(@NotNull ItemStack item) {
        if (item.getItemMeta().hasItemFlag(XItemFlag.HIDE_ENCHANTS.get())) {
            return Collections.emptyList();
        }
        return item.getEnchantments().entrySet().stream().map(entry -> {
            XEnchantment enchant = XEnchantment.matchXEnchantment((Enchantment)entry.getKey());
            TextComponent romanLevel = Component.text(RomanNumerals.convertTo((Integer)entry.getValue()));
            return LocaleHelper.getTranslation(enchant).append(Component.text(" ")).append(romanLevel).color(NamedTextColor.GRAY);
        }).collect(Collectors.toList());
    }

    @NotNull
    public static Component createHoverComponent(@NotNull ItemStack itemStack) {
        Component displayName = ItemHelper.getDisplayName(itemStack);
        ArrayList<Component> hoverContent = new ArrayList<Component>();
        hoverContent.add(displayName);
        hoverContent.addAll(ItemHelper.getEnchantments(itemStack));
        hoverContent.addAll(ItemHelper.getLore(itemStack));
        return displayName.hoverEvent((HoverEventSource)Components.joinNewLines(hoverContent));
    }

    @Generated
    private ItemHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

