/*
 * Decompiled with CFR 0.152.
 */
package xyz.actrium.graves.storage.impl;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bson.Document;
import org.bson.conversions.Bson;
import xyz.actrium.graves.ActriumGraves;
import xyz.actrium.graves.config.impl.StorageConfig;
import xyz.actrium.graves.death.Death;
import xyz.actrium.graves.storage.GraveStorage;
import xyz.actrium.graves.util.ItemUtils;
import xyz.actrium.graves.util.LocationUtils;

public class GraveMongoStorage
implements GraveStorage {
    private MongoClient client;
    private MongoDatabase database;
    private MongoCollection<Document> gravesCollection;

    @Override
    public void init(ActriumGraves plugin) {
        StorageConfig storageConfig = plugin.getConfigHandler().getStorageConfig();
        Object uri = "mongodb://";
        if (storageConfig.authed) {
            uri = (String)uri + storageConfig.username + ":" + storageConfig.password + "@";
        }
        uri = (String)uri + storageConfig.host + ":" + storageConfig.port;
        this.client = new MongoClient(new MongoClientURI((String)uri));
        this.database = this.client.getDatabase(storageConfig.dbName);
        this.gravesCollection = this.database.getCollection("graves");
    }

    @Override
    public void onDisable() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            ActriumGraves.get().logger.error("Failed to properly close the Mongo database. ");
            e.printStackTrace();
        }
    }

    @Override
    public List<Death> getGraves() throws IOException, ClassNotFoundException {
        ArrayList<Death> toReturn = new ArrayList<Death>();
        for (Document document : this.gravesCollection.find()) {
            String locString = document.getString((Object)"location");
            if (!LocationUtils.worldExists(locString)) {
                this.gravesCollection.deleteOne((Bson)document);
                continue;
            }
            Death data = new Death(LocationUtils.locationFromString(locString), LocationUtils.locationFromString(document.getString((Object)"actualDeathLocation")), UUID.fromString(document.getString((Object)"owner")), document.getLong((Object)"created"), ItemUtils.convertStringToitems(document.getString((Object)"contents")));
            toReturn.add(data);
        }
        return toReturn;
    }

    @Override
    public void saveGrave(Death data) throws IOException {
        Document document = new Document();
        document.append("owner", (Object)data.getPlayerId());
        document.append("location", (Object)LocationUtils.locationToString(data.getGraveLocation()));
        document.append("actualDeathLocation", (Object)LocationUtils.locationToString(data.getDeathLocation()));
        document.append("created", (Object)data.getTimeOfDeath());
        document.append("contents", (Object)ItemUtils.convertItemsToString(data.getInventoryContents()));
        this.gravesCollection.insertOne((Object)document);
    }

    @Override
    public void removeGrave(Death data) {
        Document search = new Document("location", (Object)LocationUtils.locationToString(data.getGraveLocation()));
        this.gravesCollection.findOneAndDelete((Bson)search);
    }
}

