/*
 * Decompiled with CFR 0.152.
 */
package xyz.actrium.graves;

import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.actrium.graves.Permissions;
import xyz.actrium.graves.bstats.Metrics;
import xyz.actrium.graves.commands.ActriumGravesCommand;
import xyz.actrium.graves.commands.GraveCommand;
import xyz.actrium.graves.commands.subcommands.AdminDeleteGraveSubCommand;
import xyz.actrium.graves.commands.subcommands.GraveInfoSubCommand;
import xyz.actrium.graves.config.ConfigHandler;
import xyz.actrium.graves.listeners.GraveInteractListener;
import xyz.actrium.graves.listeners.ItemUseListener;
import xyz.actrium.graves.listeners.PlayerDeathListener;
import xyz.actrium.graves.listeners.PlayerJoinListener;
import xyz.actrium.graves.listeners.PlayerRespawnListener;
import xyz.actrium.graves.listeners.block.BlockBreakListeners;
import xyz.actrium.graves.managers.GraveManager;
import xyz.actrium.graves.managers.ItemManager;
import xyz.actrium.graves.managers.StorageManager;
import xyz.actrium.graves.update.UpdateChecker;
import xyz.actrium.graves.util.Logger;
import xyz.actrium.graves.workers.GraveWorker;

public class ActriumGraves
extends JavaPlugin {
    private static ActriumGraves instance;
    public Logger logger;
    private Metrics metrics;
    private StorageManager storageManager;
    private ConfigHandler configHandler;
    public GraveManager graveManager;
    public ItemManager itemManager;
    public UpdateChecker updateChecker;
    public String version;
    private GraveCommand graveCommand;

    public static ActriumGraves get() {
        return instance;
    }

    public void onLoad() {
        instance = this;
        this.logger = new Logger(this);
        this.saveDefaultConfig();
        this.configHandler = new ConfigHandler(this);
        this.configHandler.init();
        this.version = this.getServer().getPluginManager().getPlugin(this.getName()).getDescription().getVersion();
    }

    public void onEnable() {
        this.metrics = new Metrics(this, 22721);
        this.configHandler.load(this.logger);
        this.registerManagers();
        PluginManager pman = this.getServer().getPluginManager();
        this.registerPermissions(pman);
        this.registerListeners(pman);
        this.registerCommands();
        new GraveWorker().runTaskTimer((Plugin)this, 0L, 2L);
        if (!this.updateChecker.isFailed()) {
            this.updateChecker.sendConsoleStatus(this.logger);
        }
        this.metrics.addCustomChart(new Metrics.SingleLineChart("graves", () -> this.getStorageHandler().getGraveStorage().getGraves().size()));
    }

    public void onDisable() {
        this.metrics.shutdown();
        this.storageManager.getGraveStorage().onDisable();
    }

    private void registerManagers() {
        this.storageManager = new StorageManager(this);
        this.updateChecker = new UpdateChecker(this.version);
        this.graveManager = new GraveManager(this);
        this.itemManager = new ItemManager();
    }

    private void registerPermissions(PluginManager pluginManager) {
        Permissions[] perms;
        for (Permissions value : perms = Permissions.values()) {
            pluginManager.addPermission(new Permission(value.asString(), value.getDescription()));
        }
    }

    private void registerListeners(PluginManager pman) {
        pman.registerEvents((Listener)new PlayerDeathListener(), (Plugin)this);
        pman.registerEvents((Listener)new PlayerRespawnListener(), (Plugin)this);
        pman.registerEvents((Listener)new GraveInteractListener(), (Plugin)this);
        pman.registerEvents((Listener)new BlockBreakListeners(), (Plugin)this);
        pman.registerEvents((Listener)new PlayerJoinListener(this.updateChecker), (Plugin)this);
        pman.registerEvents((Listener)new ItemUseListener(), (Plugin)this);
    }

    private void registerCommands() {
        this.getCommand("ActriumGraves").setExecutor((CommandExecutor)new ActriumGravesCommand());
        this.graveCommand = new GraveCommand();
        this.graveCommand.registerSubCommand(new AdminDeleteGraveSubCommand());
        this.graveCommand.registerSubCommand(new GraveInfoSubCommand());
        this.getCommand("grave").setExecutor((CommandExecutor)this.graveCommand);
    }

    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    public void reloadConfig() {
        super.reloadConfig();
        this.configHandler.load(this.logger);
    }

    public void saveConfig() {
        super.saveConfig();
        this.configHandler.load(this.logger);
    }

    public StorageManager getStorageHandler() {
        return this.storageManager;
    }

    public ItemManager getItemHandler() {
        return this.itemManager;
    }

    public void disable() {
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }
}

