/*
 * Decompiled with CFR 0.152.
 */
package xyz.skitbet.graves;

import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.skitbet.graves.commands.SkitGravesCommand;
import xyz.skitbet.graves.config.ConfigHandler;
import xyz.skitbet.graves.grave.GraveHandler;
import xyz.skitbet.graves.listeners.CompassUseListener;
import xyz.skitbet.graves.listeners.GraveInteractListener;
import xyz.skitbet.graves.listeners.PlayerDeathListener;
import xyz.skitbet.graves.listeners.PlayerJoinListener;
import xyz.skitbet.graves.listeners.PlayerRespawnListener;
import xyz.skitbet.graves.listeners.block.BlockBreakListeners;
import xyz.skitbet.graves.storage.StorageHandler;
import xyz.skitbet.graves.update.UpdateHandler;
import xyz.skitbet.graves.util.Logger;
import xyz.skitbet.graves.workers.GraveWorker;

public class GravesPlugin
extends JavaPlugin {
    private static GravesPlugin instance;
    public Logger logger;
    private StorageHandler storageHandler;
    private ConfigHandler configHandler;
    public GraveHandler graveHandler;
    public UpdateHandler updateHandler;
    public String version;

    public static GravesPlugin get() {
        return instance;
    }

    public void onLoad() {
        this.logger = new Logger(this);
        this.configHandler = new ConfigHandler(this);
        this.saveDefaultConfig();
        this.configHandler.init();
        this.version = this.getServer().getPluginManager().getPlugin(this.getName()).getDescription().getVersion();
    }

    public void onEnable() {
        instance = this;
        this.configHandler.load(this.logger);
        this.updateHandler = new UpdateHandler(this.version);
        this.storageHandler = new StorageHandler(this);
        PluginManager pman = this.getServer().getPluginManager();
        pman.registerEvents((Listener)new PlayerDeathListener(), (Plugin)this);
        pman.registerEvents((Listener)new PlayerRespawnListener(), (Plugin)this);
        pman.registerEvents((Listener)new GraveInteractListener(), (Plugin)this);
        pman.registerEvents((Listener)new BlockBreakListeners(), (Plugin)this);
        pman.registerEvents((Listener)new PlayerJoinListener(this.updateHandler), (Plugin)this);
        pman.registerEvents((Listener)new CompassUseListener(), (Plugin)this);
        this.graveHandler = new GraveHandler(this);
        this.getCommand("skitgraves").setExecutor((CommandExecutor)new SkitGravesCommand());
        new GraveWorker().runTaskTimer((Plugin)this, 0L, 2L);
        this.logger.noPrefix("&r ");
        this.updateHandler.sendConsoleStatus(this.logger);
    }

    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    public void reloadConfig() {
        super.reloadConfig();
        this.configHandler.load(this.logger);
    }

    public void saveConfig() {
        super.saveConfig();
        this.configHandler.load(this.logger);
    }

    public StorageHandler getStorageHandler() {
        return this.storageHandler;
    }

    public void disable() {
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }
}

