/*
 * Decompiled with CFR 0.152.
 */
package xyz.skitbet.graves.config;

import java.io.File;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import xyz.skitbet.graves.GravesPlugin;
import xyz.skitbet.graves.storage.StorageType;
import xyz.skitbet.graves.util.BlockUtils;
import xyz.skitbet.graves.util.Logger;

public class ConfigHandler {
    private File file;
    private FileConfiguration configuration;
    private final GravesPlugin plugin;
    public boolean checkForUpdates;
    public StorageType storageType;
    public String dbHost;
    public int dbPort;
    public String dbName;
    public boolean authed;
    public String dbUser;
    public String dbPass;
    public boolean compassEnabled;
    public boolean privateGraves;
    public int maxGraves;
    public int removeTime;
    public Material blockUnder;
    public String wrongPlayer;
    public String graveDeleted;
    public String graveExpired;
    public String breakMessage;
    public String maxGravesMessage;
    public String itemClickMessage;

    public ConfigHandler(GravesPlugin gravesPlugin) {
        this.plugin = gravesPlugin;
    }

    private void loadFields() {
        this.checkForUpdates = this.configuration.getBoolean("check-updates");
        if (!StorageType.valid(this.configuration.getString("storage-type"))) {
            GravesPlugin.get().logger.error(this.configuration.getString("storage-type") + " is not a valid storage type.");
            GravesPlugin.get().disable();
            return;
        }
        this.storageType = StorageType.valueOf(this.configuration.getString("storage-type").toUpperCase());
        this.dbHost = this.configuration.getString("storage-info.host");
        this.dbPort = this.configuration.getInt("storage-info.port");
        this.dbName = this.configuration.getString("storage-info.dbName");
        this.authed = this.configuration.getBoolean("storage-info.auth.authed");
        this.dbUser = this.configuration.getString("storage-info.auth.username");
        this.dbPass = this.configuration.getString("storage-info.auth.password");
        this.compassEnabled = this.configuration.getBoolean("compass-enabled");
        this.privateGraves = this.configuration.getBoolean("private-graves");
        this.maxGraves = this.configuration.getInt("max-graves");
        this.removeTime = this.configuration.getInt("remove-time");
        Material material = Material.getMaterial((String)this.configuration.getString("block-under").toUpperCase());
        if (material == null) {
            GravesPlugin.get().logger.error(this.configuration.getString("block-under") + " is not a valid block, make sure you are using bukkit/spigot names.\nIE: Cobblestone would be cobblestone, Oak Log would be oak_log");
            GravesPlugin.get().disable();
            return;
        }
        if (BlockUtils.isValidMaterialType(material)) {
            GravesPlugin.get().logger.error(this.configuration.getString("block-under") + " is not a valid block, please use a block thats a solid, and has no physics.");
            GravesPlugin.get().disable();
            return;
        }
        this.blockUnder = material;
        this.wrongPlayer = this.formatMessage(this.configuration.getString("messages.wrong-player"));
        this.graveDeleted = this.formatMessage(this.configuration.getString("messages.grave-deleted"));
        this.graveExpired = this.formatMessage(this.configuration.getString("messages.grave-expired"));
        this.breakMessage = this.formatMessage(this.configuration.getString("messages.break"));
        this.maxGravesMessage = this.formatMessage(this.configuration.getString("messages.max-graves"));
        this.itemClickMessage = this.formatMessage(this.configuration.getString("messages.item-click"));
    }

    public void init() {
        File file = new File(this.plugin.getDataFolder(), "config.yml");
        if (!file.exists()) {
            this.plugin.logger.error("Config file was deleted or not created, please restart your server to create it.");
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
            return;
        }
        this.configuration = this.plugin.getConfig();
    }

    public void load(Logger logger) {
        try {
            if (this.configuration == null) {
                return;
            }
            this.loadFields();
            logger.info("Config has been loaded");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.plugin.logger.error("Failed to load configuration, please check the config.");
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
        }
    }

    public String formatMessage(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String formatPlayerMessage(Player player, String message) {
        return message.replaceAll("%player%", player.getDisplayName());
    }
}

