/*
 * Decompiled with CFR 0.152.
 */
package xyz.skitbet.graves.grave;

import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import xyz.skitbet.graves.util.BlockUtils;
import xyz.skitbet.graves.util.LocationUtils;

public class GraveData {
    private final UUID uuid;
    public Location actualDeathLocation;
    public Location location;
    public long timeCreated;
    public final ItemStack[] contents;

    public GraveData(Player player) {
        this.uuid = player.getUniqueId();
        Location newLoc = BlockUtils.getGraveSpot(player.getLocation().getBlock().getLocation());
        player.sendMessage(ChatColor.GREEN + "Your grave has been spawned at " + LocationUtils.convertToFancyText(newLoc, ChatColor.GREEN, ChatColor.GRAY));
        this.actualDeathLocation = player.getLocation();
        this.location = newLoc;
        this.timeCreated = System.currentTimeMillis();
        this.contents = player.getInventory().getContents();
    }

    public GraveData(Location location, Location actualDeathLocation, UUID uuid, long timeCreated, ItemStack[] stacks) {
        this.location = location;
        this.actualDeathLocation = actualDeathLocation;
        this.uuid = uuid;
        this.timeCreated = timeCreated;
        this.contents = stacks;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Location getLocation() {
        return this.location;
    }

    public Location getActualDeathLocation() {
        return this.actualDeathLocation;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public ItemStack[] getContents() {
        return this.contents;
    }

    public String toString() {
        return LocationUtils.locationToString(this.location) + ", " + this.timeCreated;
    }
}

