/*
 * Decompiled with CFR 0.152.
 */
package xyz.skitbet.graves.grave;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import xyz.skitbet.graves.GravesPlugin;
import xyz.skitbet.graves.config.ConfigHandler;
import xyz.skitbet.graves.grave.GraveData;

public class GraveHandler {
    public static final ConfigHandler configHandler = GravesPlugin.get().getConfigHandler();
    private static GraveHandler instance;
    public ConcurrentHashMap<Location, GraveData> graves = new ConcurrentHashMap();

    public static GraveHandler get() {
        return instance == null ? new GraveHandler(GravesPlugin.get()) : instance;
    }

    public GraveHandler(GravesPlugin plugin) {
        instance = this;
        this.load();
    }

    public void load() {
        try {
            for (GraveData grave : GravesPlugin.get().getStorageHandler().getStorage().getGraves()) {
                this.graves.put(grave.getLocation(), grave);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        GravesPlugin.get().logger.info("Loaded " + this.graves.size() + " unclaimed graves in storage.");
    }

    public void createGrave(GraveData data) throws IOException {
        this.saveGrave(data);
        this.graves.put(data.getLocation(), data);
        Location locDeath = data.getLocation().clone();
        Player player = Bukkit.getPlayer((UUID)data.getUuid());
        locDeath.getBlock().setType(Material.PLAYER_HEAD);
        Skull skull = (Skull)locDeath.getBlock().getState();
        skull.setOwner(player.getName());
        skull.update();
        skull.setMetadata("grave", (MetadataValue)new FixedMetadataValue((Plugin)GravesPlugin.get(), (Object)player.getUniqueId().toString()));
        Location signLoc = locDeath.clone().add(1.0, 0.0, 0.0);
        signLoc.getBlock().setType(Material.OAK_SIGN);
        Sign sign = (Sign)signLoc.getBlock().getState();
        sign.setLine(1, "R.I.P");
        sign.setLine(2, player.getDisplayName());
        sign.update();
        if (GraveHandler.configHandler.blockUnder != Material.AIR) {
            locDeath.clone().subtract(0.0, 1.0, 0.0).getBlock().setType(GraveHandler.configHandler.blockUnder);
        }
    }

    public void removeGrave(GraveData data) {
        Block graveBlock = data.getLocation().getBlock();
        Block signBlock = data.getLocation().getBlock().getLocation().clone().add(1.0, 0.0, 0.0).getBlock();
        graveBlock.setType(Material.AIR);
        graveBlock.removeMetadata("grave", (Plugin)GravesPlugin.get());
        if (signBlock.getType() == Material.OAK_SIGN) {
            signBlock.setType(Material.AIR);
        }
        GravesPlugin.get().getStorageHandler().getStorage().removeGrave(data);
        this.graves.remove(data.getLocation());
    }

    public void saveGrave(GraveData data) throws IOException {
        GravesPlugin.get().getStorageHandler().getStorage().saveGrave(data);
    }

    public boolean isGrave(Location lastDeathLoc) {
        return this.graves.containsKey(lastDeathLoc.getBlock().getLocation());
    }

    public CompletableFuture<Boolean> isGraveAsync(Location lastDeathLoc) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.graves.containsKey(lastDeathLoc.getBlock().getLocation())) {
                return true;
            }
            return false;
        });
    }

    public GraveData getGrave(Location location) {
        return this.graves.get(location);
    }

    public long getPlayerGraveCount(Player player) {
        return this.graves.values().stream().filter(data -> data.getUuid().toString().equals(player.getUniqueId().toString())).count();
    }

    public CompletableFuture<GraveData> getGraveAsync(Location lastDeathLoc, Player player) {
        return CompletableFuture.supplyAsync(() -> this.graves.values().stream().filter(data -> data.getActualDeathLocation() == lastDeathLoc).filter(data -> data.getUuid().toString().equals(player.getUniqueId().toString())).findFirst().orElse(null));
    }

    public CompletableFuture<GraveData> getLastGrave(Player player) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                List<GraveData> playerGraves = this.getPlayerGraves(player).get();
                playerGraves.sort((o1, o2) -> Long.compare(o2.getTimeCreated(), o1.getTimeCreated()));
                return playerGraves.stream().findFirst().orElse(null);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    public CompletableFuture<List<GraveData>> getPlayerGraves(Player player) {
        return CompletableFuture.supplyAsync(() -> this.graves.values().stream().filter(data -> data.getUuid().toString().equals(player.getUniqueId().toString())).collect(Collectors.toList()));
    }
}

