/*
 * Decompiled with CFR 0.152.
 */
package xyz.skitbet.graves.listeners;

import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import xyz.skitbet.graves.GravesPlugin;
import xyz.skitbet.graves.grave.GraveHandler;
import xyz.skitbet.graves.util.CompassHelper;

public class CompassUseListener
implements Listener {
    private final HashMap<Player, Long> cooldowns = new HashMap();

    @EventHandler
    public void useItem(PlayerInteractEvent event) {
        if (!GravesPlugin.get().getConfigHandler().compassEnabled) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        boolean isCooldown = this.shouldCooldown(event.getPlayer());
        if (isCooldown) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack stack = event.getItem();
        if (stack == null) {
            return;
        }
        if (!CompassHelper.isCompass(stack)) {
            return;
        }
        Location loc = CompassHelper.getGraveLocation(stack);
        if (!GraveHandler.get().isGrave(loc)) {
            player.getInventory().remove(event.getItem());
            return;
        }
        int distance = (int)loc.distance(player.getLocation());
        player.sendMessage(GravesPlugin.get().getConfigHandler().itemClickMessage.replaceAll("%distance%", String.valueOf(distance)));
    }

    public boolean shouldCooldown(Player player) {
        if (this.cooldowns.containsKey(player)) {
            if (System.currentTimeMillis() - this.cooldowns.get(player) >= 3500L) {
                this.cooldowns.remove(player);
                return false;
            }
            return true;
        }
        return false;
    }
}

