/*
 * Decompiled with CFR 0.152.
 */
package xyz.skitbet.graves.listeners;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import xyz.skitbet.graves.GravesPlugin;
import xyz.skitbet.graves.grave.GraveData;
import xyz.skitbet.graves.grave.GraveHandler;
import xyz.skitbet.graves.util.CompassHelper;

public class GraveInteractListener
implements Listener {
    private HashMap<Player, Long> cooldown = new HashMap();

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        boolean isCooldown = this.shouldCooldown(event.getPlayer());
        if (isCooldown) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!GraveHandler.get().isGrave(event.getClickedBlock().getLocation())) {
            return;
        }
        Player player = event.getPlayer();
        this.cooldown.put(player, System.currentTimeMillis());
        Block graveBlock = event.getClickedBlock();
        GraveData data = GraveHandler.get().getGrave(graveBlock.getLocation());
        if (data == null) {
            player.sendMessage(GravesPlugin.get().getConfigHandler().graveDeleted);
            return;
        }
        if (!player.getUniqueId().equals(data.getUuid()) && GravesPlugin.get().getConfigHandler().privateGraves) {
            Player toBelongTo = Bukkit.getPlayer((UUID)data.getUuid());
            player.sendMessage(GravesPlugin.get().getConfigHandler().formatPlayerMessage(toBelongTo, GravesPlugin.get().getConfigHandler().wrongPlayer));
            return;
        }
        GraveHandler.get().removeGrave(data);
        for (ItemStack content : data.getContents()) {
            if (content == null) continue;
            player.getWorld().dropItemNaturally(data.getLocation(), content);
        }
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_ANVIL_DESTROY, 1.0f, 1.0f);
        CompassHelper.removeCompass(player);
    }

    public boolean shouldCooldown(Player player) {
        if (this.cooldown.containsKey(player)) {
            if (System.currentTimeMillis() - this.cooldown.get(player) >= 1000L) {
                this.cooldown.remove(player);
                return false;
            }
            return true;
        }
        return false;
    }
}

