/*
 * Decompiled with CFR 0.152.
 */
package xyz.skitbet.graves.listeners;

import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import xyz.skitbet.graves.GravesPlugin;
import xyz.skitbet.graves.config.ConfigHandler;
import xyz.skitbet.graves.grave.GraveData;
import xyz.skitbet.graves.grave.GraveHandler;

public class PlayerDeathListener
implements Listener {
    private final ConfigHandler configHandler = GravesPlugin.get().getConfigHandler();

    @EventHandler
    public void onDeath(EntityDamageEvent event) {
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!(player.getHealth() - event.getFinalDamage() <= 0.0)) {
            return;
        }
        try {
            if (GraveHandler.get().getPlayerGraveCount(player) >= (long)this.configHandler.maxGraves) {
                player.sendMessage(this.configHandler.maxGravesMessage);
                return;
            }
            GraveData graveData = new GraveData(player);
            GraveHandler.get().createGrave(graveData);
            player.getInventory().clear();
        }
        catch (IOException e) {
            player.sendMessage(ChatColor.RED + "Sorry, seems like there was a error while saving your grave.");
        }
    }
}

