/*
 * Decompiled with CFR 0.152.
 */
package xyz.skitbet.graves.listeners.block;

import java.util.concurrent.ExecutionException;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import xyz.skitbet.graves.GravesPlugin;
import xyz.skitbet.graves.grave.GraveHandler;

public class BlockBreakListeners
implements Listener {
    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        try {
            if (!GraveHandler.get().isGraveAsync(event.getBlock().getLocation()).get().booleanValue()) {
                return;
            }
            event.setCancelled(true);
            event.getPlayer().sendMessage(GravesPlugin.get().getConfigHandler().breakMessage);
        }
        catch (InterruptedException | ExecutionException e) {
            event.getPlayer().sendMessage(ChatColor.RED + "An error accord while checking if block was a grave.");
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onExplode(BlockExplodeEvent event) {
        try {
            if (!GraveHandler.get().isGraveAsync(event.getBlock().getLocation()).get().booleanValue()) {
                return;
            }
            event.setCancelled(true);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        try {
            for (Block block : event.blockList()) {
                if (!GraveHandler.get().isGraveAsync(block.getLocation()).get().booleanValue()) continue;
                event.blockList().remove(block);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @EventHandler
    public void onBurn(BlockBurnEvent event) {
        try {
            if (!GraveHandler.get().isGraveAsync(event.getBlock().getLocation()).get().booleanValue()) {
                return;
            }
            event.setCancelled(true);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }
}

