/*
 * Decompiled with CFR 0.152.
 */
package xyz.skitbet.graves.storage.impl;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bson.Document;
import org.bson.conversions.Bson;
import xyz.skitbet.graves.GravesPlugin;
import xyz.skitbet.graves.config.ConfigHandler;
import xyz.skitbet.graves.grave.GraveData;
import xyz.skitbet.graves.storage.IStorage;
import xyz.skitbet.graves.util.ItemUtils;
import xyz.skitbet.graves.util.LocationUtils;

public class MongoStorage
implements IStorage {
    private MongoClient client;
    private MongoDatabase database;
    private MongoCollection<Document> gravesCollection;

    @Override
    public void init(GravesPlugin plugin) {
        Object uri = "mongodb://";
        ConfigHandler configHandler = plugin.getConfigHandler();
        if (configHandler.authed) {
            uri = (String)uri + configHandler.dbUser + ":" + configHandler.dbPass + "@";
        }
        uri = (String)uri + configHandler.dbHost + ":" + configHandler.dbPass;
        this.client = new MongoClient(new MongoClientURI((String)uri));
        this.database = this.client.getDatabase(configHandler.dbName);
        this.gravesCollection = this.database.getCollection("graves");
    }

    @Override
    public List<GraveData> getGraves() throws IOException, ClassNotFoundException {
        ArrayList<GraveData> toReturn = new ArrayList<GraveData>();
        for (Document document : this.gravesCollection.find()) {
            GraveData data = new GraveData(LocationUtils.locationFromString(document.getString((Object)"location")), LocationUtils.locationFromString(document.getString((Object)"actualDeathLocation")), UUID.fromString(document.getString((Object)"owner")), document.getLong((Object)"created"), ItemUtils.convertStringToitems(document.getString((Object)"contents")));
            toReturn.add(data);
        }
        return toReturn;
    }

    @Override
    public void saveGrave(GraveData data) throws IOException {
        Document document = new Document();
        document.append("owner", (Object)data.getUuid());
        document.append("location", (Object)LocationUtils.locationToString(data.getLocation()));
        document.append("actualDeathLocation", (Object)LocationUtils.locationToString(data.getActualDeathLocation()));
        document.append("created", (Object)data.getTimeCreated());
        document.append("contents", (Object)ItemUtils.convertItemsToString(data.getContents()));
        this.gravesCollection.insertOne((Object)document);
    }

    @Override
    public void removeGrave(GraveData data) {
        Document search = new Document("location", (Object)LocationUtils.locationToString(data.getLocation()));
        this.gravesCollection.findOneAndDelete((Bson)search);
    }
}

