/*
 * Decompiled with CFR 0.152.
 */
package xyz.skitbet.graves.storage.impl;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import xyz.skitbet.graves.GravesPlugin;
import xyz.skitbet.graves.config.ConfigHandler;
import xyz.skitbet.graves.grave.GraveData;
import xyz.skitbet.graves.storage.IStorage;
import xyz.skitbet.graves.util.ItemUtils;
import xyz.skitbet.graves.util.LocationUtils;

public class SQLStorage
implements IStorage {
    private Connection con;

    @Override
    public void init(GravesPlugin plugin) {
        ConfigHandler configHandler = plugin.getConfigHandler();
        String uri = "jdbc:mysql://" + configHandler.dbHost + ":" + configHandler.dbPort + "/" + configHandler.dbName;
        try {
            this.con = GravesPlugin.get().getConfigHandler().authed ? DriverManager.getConnection(uri, configHandler.dbUser, configHandler.dbPass) : DriverManager.getConnection(uri);
            String createTable = "CREATE TABLE IF NOT EXISTS graves (location VARCHAR(255) PRIMARY KEY,actualDeathLocation VARCHAR(255),uuid VARCHAR(255),created BIGINT,contents TEXT)";
            Statement statement = this.con.createStatement();
            statement.executeUpdate(createTable);
        }
        catch (SQLException e) {
            GravesPlugin.get().logger.error("Failed to connect to SQL database. " + e.getErrorCode());
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<GraveData> getGraves() {
        ArrayList<GraveData> toReturn = new ArrayList<GraveData>();
        try (Statement statement = this.con.createStatement();){
            ResultSet resultSet = statement.executeQuery("SELECT location, actualDeathLocation, uuid, created, contents FROM graves");
            while (resultSet.next()) {
                toReturn.add(new GraveData(LocationUtils.locationFromString(resultSet.getString("location")), LocationUtils.locationFromString(resultSet.getString("actualDeathLocation")), UUID.fromString(resultSet.getString("uuid")), resultSet.getLong("created"), ItemUtils.convertStringToitems(resultSet.getString("contents"))));
            }
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            GravesPlugin.get().logger.error("Failed to handle to SELECT Sql. ");
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    @Override
    public void saveGrave(GraveData data) throws IOException {
        String insertSQL = "INSERT INTO graves (location, actualDeathLocation, uuid, created, contents) VALUES (?, ?, ?, ?, ?)";
        try (PreparedStatement statement = this.con.prepareStatement(insertSQL);){
            statement.setString(1, LocationUtils.locationToString(data.getLocation()));
            statement.setString(2, LocationUtils.locationToString(data.getActualDeathLocation()));
            statement.setString(3, data.getUuid().toString());
            statement.setLong(4, data.getTimeCreated());
            statement.setString(5, ItemUtils.convertItemsToString(data.getContents()));
            int rowAffect = statement.executeUpdate();
            if (rowAffect == 0) {
                GravesPlugin.get().logger.error("Failed to save grave at location " + LocationUtils.locationToString(data.getLocation()));
            }
        }
        catch (SQLException e) {
            GravesPlugin.get().logger.error("Failed to handle to INSERT Sql. ");
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeGrave(GraveData data) {
        try (PreparedStatement statement = this.con.prepareStatement("DELETE FROM graves WHERE location = ?");){
            statement.setString(1, LocationUtils.locationToString(data.getLocation()));
            int rowAffect = statement.executeUpdate();
            if (rowAffect == 0) {
                GravesPlugin.get().logger.error("Failed to delete grave at location " + LocationUtils.locationToString(data.getLocation()));
            }
        }
        catch (SQLException e) {
            GravesPlugin.get().logger.error("Failed to handle to DELETE Sql. ");
            throw new RuntimeException(e);
        }
    }
}

