/*
 * Decompiled with CFR 0.152.
 */
package xyz.skitbet.graves.storage.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import xyz.skitbet.graves.GravesPlugin;
import xyz.skitbet.graves.grave.GraveData;
import xyz.skitbet.graves.storage.IStorage;
import xyz.skitbet.graves.util.ItemUtils;
import xyz.skitbet.graves.util.LocationUtils;

public class YamlStorage
implements IStorage {
    public FileConfiguration config;
    public File file;
    public ConfigurationSection mainSection;

    @Override
    public void init(GravesPlugin plugin) {
        try {
            this.file = new File(((World)plugin.getServer().getWorlds().get(0)).getWorldFolder(), "graves.yml");
            if (!this.file.exists()) {
                this.file.createNewFile();
                GravesPlugin.get().logger.info("Created the YML graves file in the main world folder.");
            }
            this.config = new YamlConfiguration();
            this.config.load(this.file);
            if (!this.config.isConfigurationSection("graves")) {
                this.mainSection = this.config.createSection("graves");
                return;
            }
            this.mainSection = this.config.getConfigurationSection("graves");
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<GraveData> getGraves() {
        ArrayList<GraveData> toReturn = new ArrayList<GraveData>();
        for (String key : this.mainSection.getKeys(false)) {
            ConfigurationSection sec = this.config.getConfigurationSection("graves." + key);
            Location graveLoc = LocationUtils.locationFromString(sec.getName());
            Location actualDeathLocation = LocationUtils.locationFromString(sec.getString("actual-death"));
            UUID uuid = UUID.fromString(sec.getString("uuid"));
            long created = sec.getLong("created");
            try {
                ItemStack[] items = ItemUtils.convertStringToitems(sec.getString("contents"));
                GraveData graveData = new GraveData(graveLoc, actualDeathLocation, uuid, created, items);
                toReturn.add(graveData);
            }
            catch (IOException | ClassNotFoundException e) {
                GravesPlugin.get().logger.error("Failed to get grave contents for UUID " + uuid.toString());
                throw new RuntimeException(e);
            }
        }
        return toReturn;
    }

    @Override
    public void saveGrave(GraveData data) throws IOException {
        ConfigurationSection sec = this.config.createSection("graves." + LocationUtils.locationToString(data.getLocation()));
        sec.set("uuid", (Object)data.getUuid().toString());
        sec.set("actual-death", (Object)LocationUtils.locationToString(data.getActualDeathLocation()));
        sec.set("created", (Object)data.getTimeCreated());
        sec.set("contents", (Object)ItemUtils.convertItemsToString(data.getContents()));
        this.save();
    }

    @Override
    public void removeGrave(GraveData data) {
        this.mainSection.set(LocationUtils.locationToString(data.getLocation()), null);
        this.save();
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

