/*
 * Decompiled with CFR 0.152.
 */
package xyz.skitbet.graves.update;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.bukkit.plugin.Plugin;
import xyz.skitbet.graves.GravesPlugin;
import xyz.skitbet.graves.util.CC;
import xyz.skitbet.graves.util.Logger;
import xyz.skitbet.graves.workers.UpdateWorker;

public class UpdateHandler {
    private static final String URL = "https://api.spiget.org/v2/resources/114963/versions/latest";
    public boolean outdated = false;
    private UpdateWorker worker;
    public String latestVersion;
    public String currentVersion;

    public UpdateHandler(String version) {
        if (!GravesPlugin.get().getConfigHandler().checkForUpdates) {
            this.outdated = false;
            return;
        }
        this.currentVersion = version;
        this.latestVersion = this.getLatestVersion();
        if (this.latestVersion == null) {
            return;
        }
        this.outdated = this.isVersionOutDate();
        this.worker = new UpdateWorker(this);
        this.worker.runTaskTimerAsynchronously((Plugin)GravesPlugin.get(), 300L, 2400L);
    }

    public void refresh() {
        String version = this.getLatestVersion();
        if (version == null) {
            this.latestVersion = this.currentVersion;
            this.outdated = false;
            this.worker.cancel();
            return;
        }
        this.latestVersion = version;
        this.outdated = this.isVersionOutDate();
        if (this.outdated) {
            this.worker.cancel();
        }
    }

    public void sendConsoleStatus(Logger logger) {
        if (this.outdated) {
            logger.info("&cYou are running a outdated version of SkitGraves!");
            logger.info("&cLatest version: " + this.latestVersion);
            logger.info("&cYour version: " + this.currentVersion);
            return;
        }
        logger.info(CC.translate("You are running the latest version (" + this.currentVersion + ") of SkitGraves!"));
    }

    public String getLatestVersion() {
        try {
            String line;
            URL url = new URL("https://api.spiget.org/v2/resources/114963/versions/latest?" + System.currentTimeMillis());
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder jsonString = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                jsonString.append(line);
            }
            reader.close();
            JsonObject infoJson = (JsonObject)new Gson().fromJson(jsonString.toString(), JsonObject.class);
            return infoJson.get("name").getAsString();
        }
        catch (IOException e) {
            GravesPlugin.get().logger.error("Failed to check for a update! Check your internet connection.");
            return null;
        }
    }

    public boolean isVersionOutDate() {
        String[] currentArgs = this.currentVersion.split("\\.");
        String[] latestArgs = this.latestVersion.split("\\.");
        boolean returnValue = false;
        for (int i = 0; i < currentArgs.length; ++i) {
            int l;
            int c = Integer.parseInt(currentArgs[i]);
            if (c >= (l = Integer.parseInt(latestArgs[i]))) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public UpdateWorker getWorker() {
        return this.worker;
    }
}

