/*
 * Decompiled with CFR 0.152.
 */
package xyz.skitbet.graves.util;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import xyz.skitbet.graves.GravesPlugin;
import xyz.skitbet.graves.grave.GraveData;
import xyz.skitbet.graves.util.LocationUtils;

public class CompassHelper {
    public static NamespacedKey compassKey = new NamespacedKey((Plugin)GravesPlugin.get(), "grave-compass");
    public static NamespacedKey graveKey = new NamespacedKey((Plugin)GravesPlugin.get(), "grave-location");
    public static NamespacedKey deathKey = new NamespacedKey((Plugin)GravesPlugin.get(), "death-location");

    public static void giveCompass(Player player, GraveData data) {
        ItemStack stack = new ItemStack(Material.COMPASS);
        CompassMeta meta = (CompassMeta)stack.getItemMeta();
        meta.setLodestone(data.getLocation());
        meta.setLodestoneTracked(false);
        meta.setDisplayName(ChatColor.GREEN + "Grave " + LocationUtils.convertToFancyText(data.getLocation(), ChatColor.GREEN, ChatColor.GREEN));
        meta.getPersistentDataContainer().set(compassKey, PersistentDataType.BOOLEAN, (Object)true);
        meta.getPersistentDataContainer().set(graveKey, PersistentDataType.STRING, (Object)LocationUtils.locationToString(data.getLocation()));
        meta.getPersistentDataContainer().set(deathKey, PersistentDataType.STRING, (Object)LocationUtils.locationToString(data.getActualDeathLocation()));
        stack.addUnsafeEnchantment(Enchantment.LUCK, 1);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        stack.setItemMeta((ItemMeta)meta);
        player.getInventory().addItem(new ItemStack[]{stack});
    }

    public static void removeCompass(Player player) {
        for (ItemStack itemStack : player.getInventory()) {
            if (itemStack == null || itemStack.getType() == Material.AIR || itemStack.getType() != Material.COMPASS || !itemStack.getItemMeta().getPersistentDataContainer().has(compassKey, PersistentDataType.BOOLEAN)) continue;
            player.getInventory().remove(itemStack);
        }
    }

    public static boolean isCompass(ItemStack itemStack) {
        if (itemStack.getType() != Material.COMPASS) {
            return false;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer pData = meta.getPersistentDataContainer();
        if (pData == null) {
            return false;
        }
        return pData.has(compassKey, PersistentDataType.BOOLEAN);
    }

    public static Location getGraveLocation(ItemStack itemStack) {
        PersistentDataContainer pData = itemStack.getItemMeta().getPersistentDataContainer();
        return LocationUtils.locationFromString((String)pData.get(graveKey, PersistentDataType.STRING));
    }

    public static Location getDeathLocation(ItemStack itemStack) {
        PersistentDataContainer pData = itemStack.getItemMeta().getPersistentDataContainer();
        return LocationUtils.locationFromString((String)pData.get(deathKey, PersistentDataType.STRING));
    }
}

