/*
 * Decompiled with CFR 0.152.
 */
package extendedtools;

import com.google.common.base.Supplier;
import extendedtools.common.item.ExtendedArmorMaterials;
import extendedtools.common.item.ExtendedItemTier;
import extendedtools.common.item.PaxelItem;
import java.util.HashMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Registers {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"extendedtools");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"extendedtools");
    public static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"extendedtools");
    public static final List<String> TYPES = List.of("axe", "hoe", "pickaxe", "shovel", "sword", "paxel");
    public static final HashMap<String, String> ARMOR_MAP = (HashMap)Util.make(() -> {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("helmet", "head");
        mappings.put("chestplate", "chest");
        mappings.put("leggings", "legs");
        mappings.put("boots", "feet");
        return mappings;
    });
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> STEEL = Registers.register("steel", ExtendedArmorMaterials.STEEL, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> BRONZE = Registers.register("bronze", ExtendedArmorMaterials.BRONZE, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> TIN = Registers.register("tin", ExtendedArmorMaterials.TIN, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> COPPER = Registers.register("copper", ExtendedArmorMaterials.COPPER, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> LEAD = Registers.register("lead", ExtendedArmorMaterials.LEAD, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> VANADIUM = Registers.register("vanadium", ExtendedArmorMaterials.VANADIUM, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> SILVER = Registers.register("silver", ExtendedArmorMaterials.SILVER, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> TITANIUM = Registers.register("titanium", ExtendedArmorMaterials.TITANIUM, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON);
    public static DeferredHolder<Item, PaxelItem> ICON;
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> MAIN;

    private static DeferredHolder<ArmorMaterial, ArmorMaterial> register(String name, ExtendedArmorMaterials material, Holder<SoundEvent> sound) {
        return ARMOR_MATERIALS.register(name, () -> new ArmorMaterial(material.map, material.enchantability, sound, () -> Ingredient.of(material.repairIng), List.of(material.layer), material.toughness, material.knockbackRes));
    }

    static {
        for (String type : TYPES) {
            for (ExtendedItemTier tier : ExtendedItemTier.values()) {
                Supplier reg = null;
                switch (type) {
                    case "axe": {
                        reg = () -> new AxeItem((Tier)tier, new Item.Properties());
                        break;
                    }
                    case "hoe": {
                        reg = () -> new HoeItem((Tier)tier, new Item.Properties());
                        break;
                    }
                    case "pickaxe": {
                        reg = () -> new PickaxeItem((Tier)tier, new Item.Properties());
                        break;
                    }
                    case "shovel": {
                        reg = () -> new ShovelItem((Tier)tier, new Item.Properties());
                        break;
                    }
                    case "sword": {
                        reg = () -> new SwordItem((Tier)tier, new Item.Properties());
                        break;
                    }
                    case "paxel": {
                        reg = () -> new PaxelItem(tier, new Item.Properties());
                        break;
                    }
                }
                ITEMS.register(type + tier.tag(), (java.util.function.Supplier)reg);
            }
        }
        for (Tiers tier : Tiers.values()) {
            DeferredHolder obj = ITEMS.register("paxel" + tier.name().toLowerCase(), () -> new PaxelItem((Tier)tier, tier == Tiers.NETHERITE ? new Item.Properties().stacksTo(1).fireResistant() : new Item.Properties().stacksTo(1)));
            if (tier != Tiers.NETHERITE) continue;
            ICON = obj;
        }
        HashMap<ExtendedArmorMaterials, DeferredHolder<ArmorMaterial, ArmorMaterial>> materialMap = new HashMap<ExtendedArmorMaterials, DeferredHolder<ArmorMaterial, ArmorMaterial>>();
        materialMap.put(ExtendedArmorMaterials.STEEL, STEEL);
        materialMap.put(ExtendedArmorMaterials.BRONZE, BRONZE);
        materialMap.put(ExtendedArmorMaterials.TIN, TIN);
        materialMap.put(ExtendedArmorMaterials.COPPER, COPPER);
        materialMap.put(ExtendedArmorMaterials.LEAD, LEAD);
        materialMap.put(ExtendedArmorMaterials.VANADIUM, VANADIUM);
        materialMap.put(ExtendedArmorMaterials.SILVER, SILVER);
        materialMap.put(ExtendedArmorMaterials.TITANIUM, TITANIUM);
        for (ExtendedArmorMaterials material : ExtendedArmorMaterials.values()) {
            for (ArmorItem.Type type : ArmorItem.Type.values()) {
                if (type == ArmorItem.Type.BODY) continue;
                ITEMS.register(ARMOR_MAP.get(type.getName()) + material.getName(), () -> new ArmorItem((Holder)materialMap.get((Object)material), type, new Item.Properties().stacksTo(1)));
            }
        }
        MAIN = CREATIVE_TABS.register("itemgroupextendedtools", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.itemgroupextendedtools")).icon(() -> new ItemStack((ItemLike)ICON.get())).build());
    }
}

