/*
 * Decompiled with CFR 0.152.
 */
package extendedtools.common.item;

import extendedtools.common.item.Tags;
import java.util.List;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public enum ExtendedItemTier implements Tier
{
    STEEL((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, (int)((double)Tiers.IRON.getUses() * 2.7), Tiers.IRON.getSpeed(), Tiers.IRON.getAttackDamageBonus() * 1.2f, 5, Tags.INGOT_STEEL),
    BRONZE((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, Tiers.IRON.getUses(), Tiers.IRON.getSpeed(), Tiers.IRON.getAttackDamageBonus(), 5, Tags.INGOT_BRONZE),
    TIN((TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, Tiers.STONE.getUses(), Tiers.STONE.getSpeed(), Tiers.IRON.getAttackDamageBonus(), 5, Tags.INGOT_TIN),
    COPPER((TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, Tiers.STONE.getUses() * 2, Tiers.STONE.getSpeed(), Tiers.STONE.getAttackDamageBonus(), 5, (TagKey<Item>)Tags.Items.INGOTS_COPPER),
    LEAD((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, Tiers.DIAMOND.getUses() * 2, Tiers.STONE.getSpeed(), Tiers.IRON.getAttackDamageBonus(), 5, Tags.INGOT_LEAD),
    VANADIUM((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, Tiers.STONE.getUses(), Tiers.IRON.getSpeed(), Tiers.IRON.getAttackDamageBonus(), 5, Tags.INGOT_VANADIUM),
    SILVER((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, (int)((double)Tiers.IRON.getUses() * 1.3), Tiers.GOLD.getSpeed(), Tiers.GOLD.getAttackDamageBonus(), 5, Tags.INGOT_SILVER),
    TITANIUM((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, Tiers.IRON.getUses() * 4, Tiers.IRON.getSpeed() * 1.1f, Tiers.IRON.getAttackDamageBonus() * 1.3f, 5, Tags.INGOT_TITANIUM);

    private final TagKey<Block> incorrectBlocksForDrops;
    private final int maxUses;
    private final float efficency;
    private final float attackDammage;
    private final int enchantability;
    private final Ingredient repairIngredient;

    private ExtendedItemTier(TagKey<Block> incorrectBlocksForDrops, int maxUses, float efficency, float attackDammage, int enchantability, TagKey<Item> repairTag) {
        this.incorrectBlocksForDrops = incorrectBlocksForDrops;
        this.maxUses = maxUses;
        this.efficency = efficency;
        this.attackDammage = attackDammage;
        this.enchantability = enchantability;
        this.repairIngredient = Ingredient.of(repairTag);
    }

    public int getUses() {
        return this.maxUses;
    }

    public float getSpeed() {
        return this.efficency;
    }

    public float getAttackDamageBonus() {
        return this.attackDammage;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public Tool createToolProperties(TagKey<Block> pBlock) {
        return new Tool(List.of(Tool.Rule.deniesDrops(this.getIncorrectBlocksForDrops()), Tool.Rule.minesAndDrops(pBlock, (float)this.getSpeed())), 1.0f, 0);
    }

    public int getEnchantmentValue() {
        return this.enchantability;
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return this.repairIngredient;
    }

    public String tag() {
        return this.name().toLowerCase();
    }
}

