/*
 * Decompiled with CFR 0.152.
 */
package extendedtools.common.item;

import extendedtools.common.item.Tags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class PaxelItem
extends DiggerItem {
    public PaxelItem(Tier tier, Item.Properties prop) {
        super(tier, Tags.PAXEL_BLOCKS, prop.durability(tier.getUses() * 2));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockState state = world.getBlockState(pos);
        BlockState result = state.getToolModifiedState(context, ItemAbilities.AXE_STRIP, false);
        if (result != null) {
            world.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            if (context.getClickedFace() == Direction.DOWN) {
                return InteractionResult.PASS;
            }
            BlockState foundResult = state.getToolModifiedState(context, ItemAbilities.SHOVEL_FLATTEN, false);
            if (foundResult != null && world.isEmptyBlock(pos.above())) {
                world.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                result = foundResult;
            } else if (state.getBlock() instanceof CampfireBlock && state.getValue((Property)CampfireBlock.LIT) == Boolean.TRUE) {
                if (!world.isClientSide) {
                    world.levelEvent(null, 1009, pos, 0);
                }
                CampfireBlock.dowse((Entity)player, (LevelAccessor)world, (BlockPos)pos, (BlockState)state);
                result = (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
            }
        }
        if (result == null) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide) {
            world.setBlock(pos, result, 3);
            if (player != null) {
                stack.hurtAndBreak(1, (LivingEntity)player, context.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            }
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_PICKAXE_ACTIONS.contains(itemAbility) || ItemAbilities.DEFAULT_AXE_ACTIONS.contains(itemAbility) || ItemAbilities.DEFAULT_SHOVEL_ACTIONS.contains(itemAbility);
    }
}

