/*
 * Decompiled with CFR 0.152.
 */
package com.doughunification.mod;

import com.doughunification.mod.DoughUnificationDataGenerator;
import com.mojang.logging.LogUtils;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.slf4j.Logger;

@Mod(value="createfddough")
public class DoughUnificationMod {
    public static final String MODID = "createfddough";
    public static final Logger LOGGER = LogUtils.getLogger();

    public DoughUnificationMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::gatherData);
        LOGGER.info("Dough Unification Mod is loading...");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Dough Unification Mod: Common setup complete!");
        LOGGER.info("Ready to unify Create and Farmer's Delight dough items!");
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new DoughUnificationDataGenerator(output, lookupProvider));
    }
}

