/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.gugle.carpet.commands;

import carpet.utils.CommandHelper;
import com.google.gson.annotations.SerializedName;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.dubhe.gugle.carpet.GcaSetting;
import dev.dubhe.gugle.carpet.tools.ComponentUtils;
import dev.dubhe.gugle.carpet.tools.FilesUtil;
import dev.dubhe.gugle.carpet.tools.IdGenerator;
import dev.dubhe.gugle.carpet.tools.ModCommands;
import dev.dubhe.gugle.carpet.tools.PosUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public class LocCommand {
    public static final FilesUtil.MapFile<Long, LocPoint> LOC_POINT = new FilesUtil.MapFile<Long, LocPoint>("loc", Long::decode, LocPoint.class);

    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.root(dispatcher, "loc").requires(stack -> CommandHelper.canUseCommand((class_2168)stack, (Object)GcaSetting.commandLoc))).executes(LocCommand::list)).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"desc", (ArgumentType)StringArgumentType.greedyString()).executes(LocCommand::add)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)LongArgumentType.longArg()).suggests(LocCommand::suggestId).executes(LocCommand::remove)))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"id", (ArgumentType)LongArgumentType.longArg()).suggests(LocCommand::suggestId).executes(LocCommand::info)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(LocCommand::list)).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(LocCommand::list))));
    }

    @NotNull
    private static CompletableFuture<Suggestions> suggestId(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(LocCommand.LOC_POINT.map.keySet().stream().map(Object::toString), (SuggestionsBuilder)builder);
    }

    public static int add(CommandContext<class_2168> context) {
        LOC_POINT.init(context);
        class_2168 source = (class_2168)context.getSource();
        long id = IdGenerator.nextId();
        String desc = StringArgumentType.getString(context, (String)"desc");
        class_243 pos = source.method_9222();
        class_5321 dim = source.method_9225().method_27983();
        LocCommand.LOC_POINT.map.put(id, new LocPoint(id, desc, pos.field_1352, pos.field_1351, pos.field_1350, (class_5321<class_1937>)dim));
        LOC_POINT.save();
        source.method_9226(() -> class_2561.method_43470((String)"Loc %s is added.".formatted(desc)), false);
        return 1;
    }

    public static int remove(CommandContext<class_2168> context) {
        LOC_POINT.init(context);
        Long id = LongArgumentType.getLong(context, (String)"id");
        LocPoint remove = (LocPoint)LocCommand.LOC_POINT.map.remove(id);
        if (remove == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No such loc id %s".formatted(id)));
            return 0;
        }
        LOC_POINT.save();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Loc %s is removed.".formatted(remove.desc)), false);
        return 1;
    }

    public static int list(CommandContext<class_2168> context) {
        int page;
        LOC_POINT.init(context);
        try {
            page = IntegerArgumentType.getInteger(context, (String)"page");
        }
        catch (IllegalArgumentException ignored) {
            page = 1;
        }
        int pageSize = 8;
        int size = LocCommand.LOC_POINT.map.size();
        int maxPage = size / 8 + 1;
        if (page > maxPage) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No such page %s".formatted(page)));
            return 0;
        }
        LocPoint[] locPoints = LocCommand.LOC_POINT.map.values().toArray(new LocPoint[0]);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"======= Loc List (Page %s/%s) =======".formatted(page, maxPage)).method_27692(class_124.field_1054));
        for (int i = (page - 1) * 8; i < size && i < page * 8; ++i) {
            ((class_2168)context.getSource()).method_45068((class_2561)LocCommand.locToComponent(locPoints[i]));
        }
        class_5250 prevPage = page <= 1 ? class_2561.method_43470((String)"<<<").method_27692(class_124.field_1080) : class_2561.method_43470((String)"<<<").method_27696(class_2583.field_24360.method_27706(class_124.field_1060).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, "/loc list " + (page - 1))));
        class_5250 nextPage = page >= maxPage ? class_2561.method_43470((String)">>>").method_27692(class_124.field_1080) : class_2561.method_43470((String)">>>").method_27696(class_2583.field_24360.method_27706(class_124.field_1060).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, "/loc list " + (page + 1))));
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"=======").method_27692(class_124.field_1054).method_27693(" ").method_10852((class_2561)prevPage).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)"(Loc %s/%s)".formatted(page, maxPage)).method_27692(class_124.field_1054)).method_27693(" ").method_10852((class_2561)nextPage).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)"=======").method_27692(class_124.field_1054)));
        return 1;
    }

    @NotNull
    private static class_5250 locToComponent(@NotNull LocPoint locPoint) {
        class_5250 component = class_2561.method_43470((String)locPoint.desc).method_27696(class_2583.field_24360.method_27706(class_124.field_1080).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)Long.toString(locPoint.id)))));
        List<class_5250> pos = PosUtils.pos(locPoint.desc, locPoint.x, locPoint.y, locPoint.z, locPoint.dimType);
        class_5250 info = class_2561.method_43470((String)"[i]").method_27696(class_2583.field_24360.method_27706(class_124.field_1054).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)"View loc point information"))).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, "/loc info %s".formatted(locPoint.id))));
        class_5250 remove = class_2561.method_43470((String)"[\ud83d\uddd1]").method_27696(class_2583.field_24360.method_27706(class_124.field_1061).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)"Remove loc point"))).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11745, "/loc remove %s".formatted(locPoint.id))));
        return class_2561.method_43470((String)"\u25b6 ").method_10852((class_2561)component).method_27693(" ").method_10852((class_2561)pos.getFirst()).method_27693(" ").method_10852((class_2561)info).method_27693(" ").method_10852((class_2561)remove);
    }

    public static int info(CommandContext<class_2168> context) {
        LOC_POINT.init(context);
        Long id = LongArgumentType.getLong(context, (String)"id");
        LocPoint point = LocCommand.LOC_POINT.map.getOrDefault(id, null);
        if (point == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No such loc id %s".formatted(id)));
            return 0;
        }
        for (class_2561 component : LocCommand.info(point)) {
            ((class_2168)context.getSource()).method_9226(() -> component, false);
        }
        return 1;
    }

    @NotNull
    public static List<class_2561> info(@NotNull LocPoint point) {
        class_5250 desc = class_2561.method_43470((String)point.desc);
        class_5250 dimType = point.dimType == class_1937.field_25180 ? class_2561.method_48321((String)"advancements.nether.root.title", (String)point.dimType.method_29177().toString()) : (point.dimType == class_1937.field_25181 ? class_2561.method_48321((String)"advancements.end.root.title", (String)point.dimType.method_29177().toString()) : (point.dimType == class_1937.field_25179 ? class_2561.method_48321((String)"flat_world_preset.minecraft.overworld", (String)point.dimType.method_29177().toString()) : class_2561.method_43470((String)point.dimType.method_29177().toString())));
        List<class_5250> pos = PosUtils.pos(point.desc, point.x, point.y, point.z, point.dimType);
        ArrayList<class_2561> result = new ArrayList<class_2561>();
        result.add((class_2561)class_2561.method_43470((String)"==================").method_27692(class_124.field_1054));
        result.add((class_2561)class_2561.method_43470((String)"Loc Point: ").method_10852((class_2561)desc));
        result.add((class_2561)class_2561.method_43470((String)"Dimension: ").method_10852((class_2561)dimType));
        if (!pos.isEmpty()) {
            result.add((class_2561)class_2561.method_43470((String)"Position: ").method_10852((class_2561)pos.get(0)));
        }
        if (pos.size() > 1) {
            result.add((class_2561)pos.get(1));
        }
        if (pos.size() > 2) {
            result.add((class_2561)class_2561.method_43470((String)"Transform Position: ").method_10852((class_2561)pos.get(2)));
        }
        if (pos.size() > 3) {
            result.add((class_2561)pos.get(3));
        }
        result.add((class_2561)class_2561.method_43470((String)"==================").method_27692(class_124.field_1054));
        return result;
    }

    public record LocPoint(long id, String desc, double x, double y, double z, @SerializedName(value="dim_type") class_5321<class_1937> dimType) {
    }
}

