/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.gugle.carpet.tools.player;

import carpet.helpers.EntityPlayerActionPack;
import com.google.common.collect.ImmutableList;
import dev.dubhe.gugle.carpet.api.menu.control.AutoResetButton;
import dev.dubhe.gugle.carpet.api.menu.control.Button;
import dev.dubhe.gugle.carpet.api.menu.control.RadioList;
import dev.dubhe.gugle.carpet.api.tools.text.Color;
import dev.dubhe.gugle.carpet.api.tools.text.ComponentTranslate;
import dev.dubhe.gugle.carpet.tools.InventoryUtil;
import dev.dubhe.gugle.carpet.tools.player.PlayerContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class PlayerInventoryContainer
extends PlayerContainer {
    public final class_2371<class_1799> items;
    public final class_2371<class_1799> armor;
    public final class_2371<class_1799> offhand;
    private final class_2371<class_1799> buttons = class_2371.method_10213((int)13, (Object)class_1799.field_8037);
    private final List<class_2371<class_1799>> compartments;
    private final RadioList hotbar;

    public PlayerInventoryContainer(class_3222 player) {
        super(player);
        this.items = InventoryUtil.getItems((class_1657)this.player);
        this.armor = InventoryUtil.getArmor((class_1657)this.player);
        this.offhand = InventoryUtil.getOffHand((class_1657)this.player);
        this.compartments = ImmutableList.of(this.items, this.armor, this.offhand, this.buttons);
        this.hotbar = PlayerInventoryContainer.createHotbarButton(this::addButton, this);
        this.createButton();
    }

    public int method_5439() {
        return this.items.size() + this.armor.size() + this.offhand.size() + this.buttons.size();
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.items) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        for (class_1799 itemStack : this.armor) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        for (class_1799 itemStack : this.offhand) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map.Entry<class_2371<class_1799>, Integer> getItemSlot(int slot) {
        return switch (slot) {
            case 0 -> Map.entry(this.buttons, 0);
            case 1, 2, 3, 4 -> Map.entry(this.armor, 4 - slot);
            case 5, 6 -> Map.entry(this.buttons, slot - 4);
            case 7 -> Map.entry(this.offhand, 0);
            case 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> Map.entry(this.buttons, slot - 5);
            case 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44 -> Map.entry(this.items, slot - 9);
            case 45, 46, 47, 48, 49, 50, 51, 52, 53 -> Map.entry(this.items, slot - 45);
            default -> null;
        };
    }

    public void method_5448() {
        for (List list : this.compartments) {
            list.clear();
        }
    }

    @NotNull
    private static RadioList createHotbarButton(BiConsumer<Integer, Button> adder, PlayerInventoryContainer container) {
        ArrayList<Button> hotBarList = new ArrayList<Button>();
        for (int i = 0; i < 9; ++i) {
            class_2561 hotBarComponent = ComponentTranslate.trans("gca.hotbar", Color.WHITE, class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10978(Boolean.valueOf(false)), new Object[]{i + 1});
            boolean defaultState = i == 0;
            Button button = new Button(defaultState, i + 1, hotBarComponent, hotBarComponent);
            int finalI = i + 1;
            button.addTurnOnFunction(() -> container.ap.setSlot(finalI));
            adder.accept(i + 9, button);
            hotBarList.add(button);
        }
        return new RadioList(hotBarList, true);
    }

    private void createButton() {
        this.addButtonList(this.hotbar);
        AutoResetButton stopAll = new AutoResetButton("gca.action.stop_all");
        Button attackInterval14 = new Button(false, "gca.action.attack.interval.12");
        Button attackContinuous = new Button(false, "gca.action.attack.continuous");
        Button useContinuous = new Button(false, "gca.action.use.continuous");
        stopAll.addTurnOnFunction(() -> {
            attackInterval14.turnOffWithoutFunction();
            attackContinuous.turnOffWithoutFunction();
            useContinuous.turnOffWithoutFunction();
            this.ap.stopAll();
        });
        attackInterval14.addTurnOnFunction(() -> {
            this.ap.start(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.interval((int)12));
            attackContinuous.turnOffWithoutFunction();
        });
        attackInterval14.addTurnOffFunction(() -> this.ap.start(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.once()));
        attackContinuous.addTurnOnFunction(() -> {
            this.ap.start(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.continuous());
            attackInterval14.turnOffWithoutFunction();
        });
        attackContinuous.addTurnOffFunction(() -> this.ap.start(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.once()));
        useContinuous.addTurnOnFunction(() -> this.ap.start(EntityPlayerActionPack.ActionType.USE, EntityPlayerActionPack.Action.continuous()));
        useContinuous.addTurnOffFunction(() -> this.ap.start(EntityPlayerActionPack.ActionType.USE, EntityPlayerActionPack.Action.once()));
        this.addButton(0, stopAll);
        this.addButton(5, attackInterval14);
        this.addButton(6, attackContinuous);
        this.addButton(8, useContinuous);
    }

    @Override
    public void tick() {
        super.tick();
        List<Button> buttonList = this.hotbar.getButtons();
        for (int i = 0; i < buttonList.size(); ++i) {
            if (i == InventoryUtil.getSelected((class_1657)this.player)) {
                buttonList.get(i).turnOnWithoutFunction();
                continue;
            }
            buttonList.get(i).turnOffWithoutFunction();
        }
    }
}

