/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.gugle.carpet.commands;

import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.dubhe.gugle.carpet.GcaSetting;
import dev.dubhe.gugle.carpet.tools.FilesUtil;
import dev.dubhe.gugle.carpet.tools.GameProfileHelper;
import dev.dubhe.gugle.carpet.tools.ModCommands;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3330;
import net.minecraft.class_3337;
import net.minecraft.class_3340;
import org.jetbrains.annotations.NotNull;

public class WlistCommand {
    public static final FilesUtil.MapFile<String, Boolean> PERMISSION = new FilesUtil.MapFile<String, Boolean>("wlist", Object::toString, Boolean.class);
    private static final SimpleCommandExceptionType ERROR_ALREADY_WHITELISTED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.whitelist.add.failed"));
    private static final SimpleCommandExceptionType ERROR_NOT_WHITELISTED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.whitelist.remove.failed"));

    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.root(dispatcher, "wlist").requires(stack -> CommandHelper.canUseCommand((class_2168)stack, (Object)GcaSetting.commandWlist) && WlistCommand.hasPermission(PERMISSION, stack))).executes(WlistCommand::list)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"permission").requires(stack -> stack.method_9259(2))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).executes(WlistCommand::permissionAdd)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).executes(WlistCommand::permissionRemove))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).suggests((commandContext, suggestionsBuilder) -> {
            class_3324 playerList = ((class_2168)commandContext.getSource()).method_9211().method_3760();
            return class_2172.method_9264(playerList.method_14571().stream().filter(serverPlayer -> !playerList.method_14590().method_14653(GameProfileHelper.prasePlayerGameProfile(serverPlayer))).map(GameProfileHelper::prasePlayerGameName), (SuggestionsBuilder)suggestionsBuilder);
        }).executes(WlistCommand::add)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).suggests((commandContext, suggestionsBuilder) -> class_2172.method_9253((String[])((class_2168)commandContext.getSource()).method_9211().method_3760().method_14560(), (SuggestionsBuilder)suggestionsBuilder)).executes(WlistCommand::remove))));
    }

    public static int add(@NotNull CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3337 userWhiteList = source.method_9211().method_3760().method_14590();
        AtomicInteger i = new AtomicInteger();
        GameProfileHelper.praseGameProfileCollection(context, "targets", (gameProfile, name, uuid) -> {
            if (!userWhiteList.method_14653(gameProfile)) {
                class_3340 userWhiteListEntry = new class_3340(gameProfile);
                userWhiteList.method_14633((class_3330)userWhiteListEntry);
                i.getAndIncrement();
                source.method_9226(() -> class_2561.method_43469((String)"commands.whitelist.add.success", (Object[])new Object[]{class_2561.method_43470((String)name)}), true);
            }
        });
        if (i.get() == 0) {
            throw ERROR_ALREADY_WHITELISTED.create();
        }
        return i.get();
    }

    public static int remove(@NotNull CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3337 userWhiteList = source.method_9211().method_3760().method_14590();
        AtomicInteger i = new AtomicInteger();
        GameProfileHelper.praseGameProfileCollection(context, "targets", (gameProfile, name, uuid) -> {
            if (userWhiteList.method_14653(gameProfile)) {
                class_3340 userWhiteListEntry = new class_3340(gameProfile);
                userWhiteList.method_14638((class_3330)userWhiteListEntry);
                i.getAndIncrement();
                source.method_9226(() -> class_2561.method_43469((String)"commands.whitelist.remove.success", (Object[])new Object[]{class_2561.method_43470((String)name)}), true);
            }
        });
        if (i.get() == 0) {
            throw ERROR_NOT_WHITELISTED.create();
        }
        source.method_9211().method_3728(source);
        return i.get();
    }

    public static int list(@NotNull CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String[] strings = source.method_9211().method_3760().method_14560();
        if (strings.length == 0) {
            source.method_9226(() -> class_2561.method_43471((String)"commands.whitelist.none"), false);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"commands.whitelist.list", (Object[])new Object[]{strings.length, String.join((CharSequence)", ", strings)}), false);
        }
        return strings.length;
    }

    public static boolean hasPermission(FilesUtil.MapFile<String, Boolean> permission, @NotNull class_2168 stack) {
        if (stack.method_9259(2)) {
            return true;
        }
        if (stack.method_43737()) {
            class_3222 player = stack.method_44023();
            if (player == null) {
                return false;
            }
            return permission.map.getOrDefault(GameProfileHelper.prasePlayerGameID(player).toString(), false);
        }
        return true;
    }

    private static int permissionAdd(CommandContext<class_2168> context) throws CommandSyntaxException {
        PERMISSION.init(context);
        AtomicInteger i = new AtomicInteger();
        GameProfileHelper.praseGameProfileCollection(context, "targets", (gameProfile, name, uuid) -> {
            WlistCommand.PERMISSION.map.put(uuid.toString(), true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Player %s has been granted permission to operate the whitelist.".formatted(name)), true);
            i.incrementAndGet();
        });
        PERMISSION.save();
        return i.get();
    }

    private static int permissionRemove(CommandContext<class_2168> context) throws CommandSyntaxException {
        PERMISSION.init(context);
        AtomicInteger i = new AtomicInteger();
        GameProfileHelper.praseGameProfileCollection(context, "targets", (gameProfile, name, uuid) -> {
            WlistCommand.PERMISSION.map.put(uuid.toString(), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Revoked player %s's permission to operate the whitelist".formatted(name)), true);
            i.incrementAndGet();
        });
        PERMISSION.save();
        return i.get();
    }
}

