/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.gugle.carpet.tools.player;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import org.jetbrains.annotations.NotNull;

public class FakePlayerAutoReplaceTool {
    public static void autoReplaceTool(@NotNull class_1657 fakePlayer, class_1792 item, class_1799 itemStack) {
        Predicate<class_1799> isDamageItem = FakePlayerAutoReplaceTool.itemDamagePredicate();
        if (isDamageItem.test(itemStack)) {
            Predicate<class_1799> predicate;
            Optional<class_1304> optional = FakePlayerAutoReplaceTool.getEquipmentSlot(fakePlayer, itemStack);
            if (optional.isEmpty()) {
                return;
            }
            class_1304 equipmentSlot = optional.get();
            boolean replaced = FakePlayerAutoReplaceTool.replaceTool(equipmentSlot, predicate = FakePlayerAutoReplaceTool.itemReplacePredicate(item), fakePlayer);
            if (replaced) {
                return;
            }
        }
    }

    private static Optional<class_1304> getEquipmentSlot(@NotNull class_1657 fakePlayer, class_1799 itemStack) {
        for (class_1304 equipmentSlot : class_1304.values()) {
            if (fakePlayer.method_6118(equipmentSlot) != itemStack) continue;
            return Optional.of(equipmentSlot);
        }
        return Optional.empty();
    }

    public static boolean replaceTool(class_1304 slot, Predicate<class_1799> predicate, @NotNull class_1657 fakePlayer) {
        if (predicate.test(fakePlayer.method_6118(slot))) {
            return true;
        }
        class_1661 inventory = fakePlayer.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960() || !predicate.test(itemStack)) continue;
            class_1799 itemBySlot = fakePlayer.method_6118(slot);
            class_1799 copy = itemStack.method_7972();
            inventory.method_5447(i, itemBySlot);
            fakePlayer.method_5673(slot, copy);
            return true;
        }
        return false;
    }

    private static Predicate<class_1799> itemDamagePredicate() {
        return itemStack -> {
            if (itemStack.method_7960()) {
                return true;
            }
            if (itemStack.method_7963()) {
                if (FakePlayerAutoReplaceTool.hasMending(itemStack)) {
                    int remaining = itemStack.method_7936() - itemStack.method_7919();
                    return remaining <= 10;
                }
                return false;
            }
            return false;
        };
    }

    private static Predicate<class_1799> itemReplacePredicate(class_1792 item) {
        return itemStack -> {
            if (itemStack.method_7909().getClass() == item.getClass()) {
                if (FakePlayerAutoReplaceTool.hasMending(itemStack)) {
                    return itemStack.method_7936() - itemStack.method_7919() > 10;
                }
                return true;
            }
            return false;
        };
    }

    private static boolean hasMending(class_1799 itemStack) {
        return class_1890.method_8225((class_1887)class_1893.field_9101, (class_1799)itemStack) > 0;
    }
}

