/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.gugle.carpet.tools;

import dev.dubhe.gugle.carpet.GcaExtension;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class IdGenerator {
    private static final long workerId;
    private static final long dataCenterId;
    private static long sequence;
    private static final long startTimestamp = 1288834974657L;
    private static final long workerIdBits = 5L;
    private static final long dataCenterIdBits = 5L;
    private static final long maxWorkerId = 31L;
    private static final long maxDataCenterId = 31L;
    private static final long sequenceBits = 12L;
    private static final long sequenceMask = 4095L;
    private static final long workerIdShift = 12L;
    private static final long dataCenterIdShift = 17L;
    private static final long timestampLeftShift = 22L;
    private static long lastTimestamp;

    private static long getMachineNum() {
        StringBuilder sb = new StringBuilder();
        Enumeration<NetworkInterface> e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e1) {
            GcaExtension.LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        if (e != null) {
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                sb.append(ni.toString());
            }
        }
        long machinePiece = sb.toString().hashCode();
        return machinePiece;
    }

    public static synchronized long nextId() {
        long timestamp = IdGenerator.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0xFFFL) == 0L) {
                timestamp = IdGenerator.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        return timestamp - 1288834974657L << 22 | dataCenterId << 17 | workerId << 12 | sequence;
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = IdGenerator.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = IdGenerator.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }

    static {
        lastTimestamp = -1L;
        workerId = IdGenerator.getMachineNum() & 0x1FL;
        dataCenterId = IdGenerator.getMachineNum() & 0x1FL;
        sequence = 0L;
    }
}

