/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.gugle.carpet;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.patches.EntityPlayerMPFake;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import dev.dubhe.gugle.carpet.GcaSetting;
import dev.dubhe.gugle.carpet.api.tools.text.ComponentTranslate;
import dev.dubhe.gugle.carpet.commands.BlistCommand;
import dev.dubhe.gugle.carpet.commands.BotCommand;
import dev.dubhe.gugle.carpet.commands.HereCommand;
import dev.dubhe.gugle.carpet.commands.LocCommand;
import dev.dubhe.gugle.carpet.commands.SopCommand;
import dev.dubhe.gugle.carpet.commands.TodoCommand;
import dev.dubhe.gugle.carpet.commands.WhereisCommand;
import dev.dubhe.gugle.carpet.commands.WlistCommand;
import dev.dubhe.gugle.carpet.tools.GameProfileHelper;
import dev.dubhe.gugle.carpet.tools.ResourceLocationSerializer;
import dev.dubhe.gugle.carpet.tools.WelcomeMessage;
import dev.dubhe.gugle.carpet.tools.player.FakePlayerResident;
import dev.dubhe.gugle.carpet.tools.serializer.ChatFormattingSerializer;
import dev.dubhe.gugle.carpet.tools.serializer.DimTypeSerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcaExtension
implements CarpetExtension,
ModInitializer {
    private static final HashSet<EntityPlayerMPFake> RESIDENT_PLAYERS = new HashSet();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(class_5321.class, (Object)new DimTypeSerializer()).registerTypeHierarchyAdapter(class_2960.class, (Object)new ResourceLocationSerializer()).registerTypeHierarchyAdapter(class_124.class, (Object)new ChatFormattingSerializer()).registerTypeHierarchyAdapter(WelcomeMessage.MessageData.class, (Object)new WelcomeMessage.MessageData.Serializer()).create();
    public static String MOD_ID = "gca";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    public static final HashMap<String, Consumer<class_3222>> ON_PLAYER_LOGGED_IN = new HashMap();
    public static final List<Map.Entry<Long, Runnable>> PLAN_FUNCTION = new ArrayList<Map.Entry<Long, Runnable>>();

    @NotNull
    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public void onPlayerLoggedIn(@NotNull class_3222 player) {
        GameProfileHelper.prasePlayerGameProfile(player, (profile, name, uuid) -> {
            Consumer<class_3222> consumer = ON_PLAYER_LOGGED_IN.remove(name);
            if (consumer != null) {
                consumer.accept(player);
            }
            if (GcaSetting.welcomePlayer) {
                WelcomeMessage.onPlayerLoggedIn(player);
            }
            if (player instanceof EntityPlayerMPFake) {
                EntityPlayerMPFake fakePlayer = (EntityPlayerMPFake)player;
                RESIDENT_PLAYERS.add(fakePlayer);
            }
        });
    }

    public void onPlayerLoggedOut(class_3222 player) {
        if (player instanceof EntityPlayerMPFake) {
            RESIDENT_PLAYERS.remove(player);
        }
    }

    public void onGameStarted() {
        CarpetServer.settingsManager.parseSettingsClass(GcaSetting.class);
    }

    public void onServerLoaded(MinecraftServer server) {
        BlistCommand.PERMISSION.init(server);
        BotCommand.BOT_INFO.init(server);
        LocCommand.LOC_POINT.init(server);
        TodoCommand.TODO.init(server);
        WlistCommand.PERMISSION.init(server);
        WelcomeMessage.WELCOME_MESSAGE.init(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServerClosed(MinecraftServer server) {
        block17: {
            try {
                if (!GcaSetting.fakePlayerResident) break block17;
                JsonObject fakePlayerList = new JsonObject();
                for (EntityPlayerMPFake player : RESIDENT_PLAYERS) {
                    class_2487 tag;
                    try (class_8942.class_11340 reporter = new class_8942.class_11340(player.method_71370(), LOGGER);){
                        class_11362 valueOutput = class_11362.method_71459((class_8942)reporter, (class_7225.class_7874)player.method_56673());
                        player.method_5647((class_11372)valueOutput);
                        tag = valueOutput.method_71475();
                    }
                    if (tag.method_10545("gca.NoResident")) continue;
                    GameProfileHelper.prasePlayerGameProfile((class_3222)player, (profile, name, uuid) -> fakePlayerList.add(name, (JsonElement)FakePlayerResident.save((class_1657)player)));
                }
                File file = server.method_27050(class_5218.field_24188).resolve("fake_player.gca.json").toFile();
                try (BufferedWriter bfw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                    bfw.write(GSON.toJson((JsonElement)fakePlayerList));
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                RESIDENT_PLAYERS.clear();
            }
        }
    }

    public void onServerLoadedWorlds(MinecraftServer server) {
        if (GcaSetting.fakePlayerResident) {
            File file = server.method_27050(class_5218.field_24188).resolve("fake_player.gca.json").toFile();
            if (!file.isFile()) {
                return;
            }
            try (BufferedReader bfr = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                JsonObject fakePlayerList = (JsonObject)GSON.fromJson((Reader)bfr, JsonObject.class);
                for (Map.Entry entry : fakePlayerList.entrySet()) {
                    FakePlayerResident.load(entry, server);
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            file.delete();
        }
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        BotCommand.register(dispatcher);
        LocCommand.register(dispatcher);
        HereCommand.register(dispatcher);
        WhereisCommand.register(dispatcher);
        TodoCommand.register(dispatcher);
        WlistCommand.register(dispatcher);
        BlistCommand.register(dispatcher);
        SopCommand.register(dispatcher);
    }

    public Map<String, String> canHasTranslations(String lang) {
        return ComponentTranslate.getTranslations(lang);
    }

    public void onInitialize() {
        CarpetServer.manageExtension((CarpetExtension)this);
    }

    @NotNull
    public static class_2960 parseLocation(String string) {
        return class_2960.method_60654((String)string);
    }
}

