/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.gugle.carpet.commands;

import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.dubhe.gugle.carpet.GcaSetting;
import dev.dubhe.gugle.carpet.tools.ComponentUtils;
import dev.dubhe.gugle.carpet.tools.FilesUtil;
import dev.dubhe.gugle.carpet.tools.IdGenerator;
import dev.dubhe.gugle.carpet.tools.ModCommands;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class TodoCommand {
    public static final FilesUtil.MapFile<Long, Todo> TODO = new FilesUtil.MapFile<Long, Todo>("todo", Long::decode, Todo.class);

    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.root(dispatcher, "todo").requires(stack -> CommandHelper.canUseCommand((class_2168)stack, (Object)GcaSetting.commandTodo))).executes(TodoCommand::list)).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"desc", (ArgumentType)StringArgumentType.greedyString()).executes(TodoCommand::add)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)LongArgumentType.longArg()).suggests(TodoCommand::suggestId).executes(TodoCommand::remove)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(TodoCommand::list)).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(TodoCommand::list)))).then(class_2170.method_9247((String)"success").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)LongArgumentType.longArg()).suggests(TodoCommand::suggestId).executes(TodoCommand::success)).then(class_2170.method_9244((String)"success", (ArgumentType)BoolArgumentType.bool()).executes(TodoCommand::success)))));
    }

    @NotNull
    private static CompletableFuture<Suggestions> suggestId(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(TodoCommand.TODO.map.keySet().stream().map(Object::toString), (SuggestionsBuilder)builder);
    }

    public static int add(CommandContext<class_2168> context) {
        TODO.init(context);
        class_2168 source = (class_2168)context.getSource();
        long id = IdGenerator.nextId();
        String desc = StringArgumentType.getString(context, (String)"desc");
        TodoCommand.TODO.map.put(id, new Todo(id, desc, false));
        TODO.save();
        source.method_9226(() -> class_2561.method_43470((String)"Todo %s is added.".formatted(desc)), false);
        return 1;
    }

    public static int remove(CommandContext<class_2168> context) {
        TODO.init(context);
        Long id = LongArgumentType.getLong(context, (String)"id");
        Todo todo = (Todo)TodoCommand.TODO.map.remove(id);
        if (todo == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No such todo id %s".formatted(id)));
            return 0;
        }
        TODO.save();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Todo %s is removed.".formatted(todo.desc)), false);
        return 1;
    }

    public static int success(CommandContext<class_2168> context) {
        boolean success;
        TODO.init(context);
        Long id = LongArgumentType.getLong(context, (String)"id");
        try {
            success = BoolArgumentType.getBool(context, (String)"success");
        }
        catch (IllegalArgumentException ignored) {
            success = true;
        }
        Todo todo = (Todo)TodoCommand.TODO.map.get(id);
        if (todo == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No such todo id %s".formatted(id)));
            return 0;
        }
        todo.success = success;
        TODO.save();
        boolean finalSuccess = success;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Todo %s has be %s.".formatted(todo.desc, finalSuccess ? "done" : "undone")), false);
        return 1;
    }

    public static int list(CommandContext<class_2168> context) {
        int page;
        TODO.init(context);
        try {
            page = IntegerArgumentType.getInteger(context, (String)"page");
        }
        catch (IllegalArgumentException ignored) {
            page = 1;
        }
        int pageSize = 8;
        int size = TodoCommand.TODO.map.size();
        int maxPage = size / 8 + 1;
        if (page > maxPage) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No such page %s".formatted(page)));
            return 0;
        }
        Todo[] todos = TodoCommand.TODO.map.values().toArray(new Todo[0]);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"======= Todo List (Page %s/%s) =======".formatted(page, maxPage)).method_27692(class_124.field_1054));
        for (int i = (page - 1) * 8; i < size && i < page * 8; ++i) {
            ((class_2168)context.getSource()).method_45068((class_2561)TodoCommand.TodoToComponent(todos[i]));
        }
        class_5250 prevPage = page <= 1 ? class_2561.method_43470((String)"<<<").method_27692(class_124.field_1080) : class_2561.method_43470((String)"<<<").method_27696(class_2583.field_24360.method_27706(class_124.field_1060).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, "/todo list " + (page - 1))));
        class_5250 nextPage = page >= maxPage ? class_2561.method_43470((String)">>>").method_27692(class_124.field_1080) : class_2561.method_43470((String)">>>").method_27696(class_2583.field_24360.method_27706(class_124.field_1060).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, "/todo list " + (page + 1))));
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"=======").method_27692(class_124.field_1054).method_27693(" ").method_10852((class_2561)prevPage).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)"(Todo %s/%s)".formatted(page, maxPage)).method_27692(class_124.field_1054)).method_27693(" ").method_10852((class_2561)nextPage).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)"=======").method_27692(class_124.field_1054)));
        return 1;
    }

    @NotNull
    private static class_5250 TodoToComponent(Todo todo) {
        class_5250 component = class_2561.method_43470((String)todo.desc).method_27696(class_2583.field_24360.method_36140(Boolean.valueOf(todo.success)).method_27706(class_124.field_1080).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)Long.toString(todo.id)))));
        class_5250 success = class_2561.method_43470((String)"[\u2714]").method_27696(class_2583.field_24360.method_27706(class_124.field_1060).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)"Make todo done"))).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, "/todo success %s".formatted(todo.id))));
        class_5250 unSuccess = class_2561.method_43470((String)"[\u274c]").method_27696(class_2583.field_24360.method_27706(class_124.field_1061).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)"Make todo undone"))).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, "/todo success %s false".formatted(todo.id))));
        class_5250 remove = class_2561.method_43470((String)"[\ud83d\uddd1]").method_27696(class_2583.field_24360.method_27706(class_124.field_1061).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)"Remove todo"))).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11745, "/todo remove %s".formatted(todo.id))));
        return class_2561.method_43470((String)(todo.success ? "\u2611" : "\u2610")).method_27693(" ").method_10852((class_2561)component).method_27693(" ").method_10852((class_2561)(todo.success ? unSuccess : success)).method_27693(" ").method_10852((class_2561)remove);
    }

    public static class Todo {
        public final Long id;
        public final String desc;
        public boolean success;

        Todo(Long id, String desc, boolean success) {
            this.id = id;
            this.desc = desc;
            this.success = success;
        }
    }
}

