/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.gugle.carpet.tools;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.context.CommandContext;
import dev.dubhe.gugle.carpet.GcaExtension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public abstract class FilesUtil {
    private static final Gson GSON = GcaExtension.GSON;
    public MinecraftServer server = null;
    private final String gcaJson;

    public FilesUtil(String jsonPrefix) {
        this.gcaJson = "%s.gca.json".formatted(jsonPrefix);
    }

    public void init(@NotNull CommandContext<class_2168> context) {
        MinecraftServer server1 = ((class_2168)context.getSource()).method_9211();
        this.init(server1);
    }

    protected abstract void createDefault(@NotNull File var1) throws IOException;

    protected abstract void init(@NotNull BufferedReader var1);

    public void init(@NotNull MinecraftServer server1) {
        if (server1 == this.server) {
            return;
        }
        this.server = server1;
        File file = this.server.method_27050(class_5218.field_24188).resolve(this.gcaJson).toFile();
        try {
            if (!file.exists()) {
                this.createDefault(file);
                return;
            }
            try (BufferedReader bfr = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                this.init(bfr);
            }
        }
        catch (IOException e) {
            GcaExtension.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void save(@NotNull BufferedWriter var1);

    public void save() {
        if (this.server == null) {
            return;
        }
        File file = this.server.method_27050(class_5218.field_24188).resolve(this.gcaJson).toFile();
        try (BufferedWriter bw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            this.save(bw);
        }
        catch (IOException e) {
            GcaExtension.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static class ObjFile<T>
    extends FilesUtil {
        public T obj;

        public ObjFile(String jsonPrefix, T defaultObj) {
            super(jsonPrefix);
            this.obj = defaultObj;
        }

        @Override
        protected void createDefault(@NotNull File file) throws IOException {
            try (BufferedWriter bw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                this.save(bw);
            }
        }

        @Override
        protected void init(@NotNull BufferedReader bfr) {
            this.obj = GSON.fromJson((Reader)bfr, this.obj.getClass());
        }

        @Override
        protected void save(@NotNull BufferedWriter bw) {
            GSON.toJson(this.obj, (Appendable)bw);
        }
    }

    public static class MapFile<K extends Comparable<K>, V>
    extends FilesUtil {
        public final Map<K, V> map = new TreeMap();
        private final Function<String, K> keyCodec;
        private final Class<V> vClass;

        public MapFile(String jsonPrefix, Function<String, K> keyCodec, Class<V> vClass) {
            super(jsonPrefix);
            this.keyCodec = keyCodec;
            this.vClass = vClass;
        }

        @Override
        protected void createDefault(@NotNull File file) throws IOException {
            try (BufferedWriter bw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                this.save(bw);
            }
        }

        @Override
        protected void init(@NotNull BufferedReader bfr) {
            this.map.clear();
            for (Map.Entry entry : ((JsonObject)GSON.fromJson((Reader)bfr, JsonObject.class)).entrySet()) {
                this.map.put((Comparable)this.keyCodec.apply((String)entry.getKey()), GSON.fromJson((JsonElement)entry.getValue(), this.vClass));
            }
        }

        @Override
        protected void save(@NotNull BufferedWriter bw) {
            GSON.toJson(this.map, (Appendable)bw);
        }
    }
}

