/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.gugle.carpet.commands;

import carpet.CarpetSettings;
import carpet.fakes.ServerPlayerInterface;
import carpet.helpers.EntityPlayerActionPack;
import carpet.patches.EntityPlayerMPFake;
import carpet.patches.FakeClientConnection;
import carpet.utils.CommandHelper;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.dubhe.gugle.carpet.GcaExtension;
import dev.dubhe.gugle.carpet.GcaSetting;
import dev.dubhe.gugle.carpet.mixin.EntityInvoker;
import dev.dubhe.gugle.carpet.mixin.PlayerAccessor;
import dev.dubhe.gugle.carpet.tools.ComponentUtils;
import dev.dubhe.gugle.carpet.tools.FilesUtil;
import dev.dubhe.gugle.carpet.tools.GameProfileHelper;
import dev.dubhe.gugle.carpet.tools.ModCommands;
import dev.dubhe.gugle.carpet.tools.player.FakePlayerSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_10264;
import net.minecraft.class_11560;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1324;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2726;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_4844;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_8791;
import net.minecraft.class_8792;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class BotCommand {
    public static final FilesUtil.MapFile<String, BotInfo> BOT_INFO = new FilesUtil.MapFile<String, BotInfo>("bot", Object::toString, BotInfo.class);
    public static final FilesUtil.MapFile<String, BotGroupInfo> BOT_GROUP_INFO = new FilesUtil.MapFile<String, BotGroupInfo>("botGroup", Object::toString, BotGroupInfo.class);

    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.root(dispatcher, "bot").requires(stack -> CommandHelper.canUseCommand((class_2168)stack, (Object)GcaSetting.commandBot))).executes(BotCommand::list)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(BotCommand::list)).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(BotCommand::list)))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"desc", (ArgumentType)StringArgumentType.greedyString()).executes(BotCommand::add))))).then(class_2170.method_9247((String)"load").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests(BotCommand::suggestPlayer).executes(BotCommand::load)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests(BotCommand::suggestPlayer).executes(BotCommand::remove)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"group").executes(BotCommand::groupList)).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(BotCommand::groupCreate)))).then(class_2170.method_9247((String)"generated").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(BotCommand::groupGenerated)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).then(class_2170.method_9244((String)"load", (ArgumentType)BoolArgumentType.bool()).executes(BotCommand::groupGenerated))).executes(BotCommand::groupGenerated))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(BotCommand::groupList)).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(BotCommand::groupList)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(BotCommand::groupRemove)))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"bot", (ArgumentType)StringArgumentType.string()).suggests(BotCommand::suggestPlayer).then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.greedyString()).suggests(BotCommand::suggestGroup).executes(BotCommand::groupAddBot))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"bot", (ArgumentType)StringArgumentType.string()).suggests(BotCommand::suggestPlayer).then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.greedyString()).suggests(BotCommand::suggestGroup).executes(BotCommand::groupRemoveBot))))).then(class_2170.method_9247((String)"load").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.greedyString()).suggests(BotCommand::suggestGroup).executes(BotCommand::groupLoadBot)))).then(class_2170.method_9247((String)"unload").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.greedyString()).suggests(BotCommand::suggestGroup).executes(BotCommand::groupUnloadBot)))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.greedyString()).suggests(BotCommand::suggestGroup).executes(BotCommand::groupInfo)))));
    }

    private static boolean groupInit(CommandContext<class_2168> context) {
        BOT_GROUP_INFO.init(context);
        BOT_INFO.init(context);
        class_2168 source = (class_2168)context.getSource();
        String groupName = StringArgumentType.getString(context, (String)"group");
        if (!BotCommand.BOT_GROUP_INFO.map.containsKey(groupName)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Group %s is not found.".formatted(groupName)));
            return true;
        }
        List<String> botNames = ((BotGroupInfo)BotCommand.BOT_GROUP_INFO.map.get((Object)groupName)).bots;
        ArrayList<String> failedBots = new ArrayList<String>();
        for (String botName : botNames) {
            if (BotCommand.BOT_INFO.map.containsKey(botName)) continue;
            failedBots.add(botName);
        }
        botNames.removeAll(failedBots);
        BotCommand.BOT_GROUP_INFO.map.put(groupName, new BotGroupInfo(groupName, botNames));
        BOT_GROUP_INFO.save();
        return false;
    }

    private static int groupInfo(CommandContext<class_2168> context) {
        int page;
        if (BotCommand.groupInit(context)) {
            return 0;
        }
        String groupName = StringArgumentType.getString(context, (String)"group");
        try {
            page = IntegerArgumentType.getInteger(context, (String)"page");
        }
        catch (IllegalArgumentException ignored) {
            page = 1;
        }
        int pageSize = 8;
        int size = ((BotGroupInfo)BotCommand.BOT_GROUP_INFO.map.get((Object)groupName)).bots.size();
        int maxPage = size / 8 + 1;
        if (page > maxPage) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No such page %s".formatted(page)));
            return 0;
        }
        ArrayList<BotInfo> botInfos = new ArrayList<BotInfo>();
        for (String botName : ((BotGroupInfo)BotCommand.BOT_GROUP_INFO.map.get((Object)groupName)).bots) {
            botInfos.add((BotInfo)BotCommand.BOT_INFO.map.get(botName));
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"======= Bot Group %s (Page %s/%s) =======".formatted(groupName, page, maxPage)).method_27692(class_124.field_1054));
        for (int i = (page - 1) * 8; i < size && i < page * 8; ++i) {
            ((class_2168)context.getSource()).method_45068((class_2561)BotCommand.botToComponent((BotInfo)botInfos.get(i)));
        }
        BotCommand.listComponent(context, page, maxPage, "/bot group show");
        return 1;
    }

    private static int groupUnloadBot(CommandContext<class_2168> context) {
        if (BotCommand.groupInit(context)) {
            return 0;
        }
        class_2168 source = (class_2168)context.getSource();
        String groupName = StringArgumentType.getString(context, (String)"group");
        List<String> botNames = ((BotGroupInfo)BotCommand.BOT_GROUP_INFO.map.get((Object)groupName)).bots;
        for (String botName : botNames) {
            class_3222 player = source.method_9211().method_3760().method_14566(botName);
            if (player == null || !(player instanceof EntityPlayerMPFake)) continue;
            EntityPlayerMPFake fake = (EntityPlayerMPFake)player;
            fake.kill((class_2561)class_2561.method_43470((String)"Killed"));
        }
        return 1;
    }

    private static int groupLoadBot(CommandContext<class_2168> context) {
        BOT_GROUP_INFO.init(context);
        BOT_INFO.init(context);
        class_2168 source = (class_2168)context.getSource();
        String groupName = StringArgumentType.getString(context, (String)"group");
        if (!BotCommand.BOT_GROUP_INFO.map.containsKey(groupName)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Group %s is not found.".formatted(groupName)));
            return 0;
        }
        List<String> botNames = ((BotGroupInfo)BotCommand.BOT_GROUP_INFO.map.get((Object)groupName)).bots;
        ArrayList<String> failedBots = new ArrayList<String>();
        for (String botName : new ArrayList<String>(botNames)) {
            if (!BotCommand.BOT_INFO.map.containsKey(botName)) {
                failedBots.add(botName);
                continue;
            }
            BotCommand.load(botName, arg_0 -> ((class_2168)source).method_9213(arg_0));
        }
        botNames.removeAll(failedBots);
        BotCommand.BOT_GROUP_INFO.map.put(groupName, new BotGroupInfo(groupName, botNames));
        BOT_GROUP_INFO.save();
        return 1;
    }

    private static int groupRemoveBot(CommandContext<class_2168> context) {
        BOT_GROUP_INFO.init(context);
        class_2168 source = (class_2168)context.getSource();
        String groupName = StringArgumentType.getString(context, (String)"group");
        String botName = StringArgumentType.getString(context, (String)"bot");
        if (!BotCommand.BOT_GROUP_INFO.map.containsKey(groupName)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Group %s is not found.".formatted(groupName)));
            return 0;
        }
        List<String> botNames = ((BotGroupInfo)BotCommand.BOT_GROUP_INFO.map.get((Object)groupName)).bots;
        if (!botNames.contains(botName)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Bot %s is not found in the %s.".formatted(botName, groupName)));
            return 0;
        }
        botNames.remove(botName);
        BotCommand.BOT_GROUP_INFO.map.put(groupName, new BotGroupInfo(groupName, botNames));
        BOT_GROUP_INFO.save();
        source.method_9226(() -> class_2561.method_43470((String)"Bot %s is removed from %s successfully.".formatted(botName, groupName)), false);
        return 1;
    }

    private static int groupAddBot(CommandContext<class_2168> context) {
        BOT_GROUP_INFO.init(context);
        BOT_INFO.init(context);
        class_2168 source = (class_2168)context.getSource();
        String groupName = StringArgumentType.getString(context, (String)"group");
        String botName = StringArgumentType.getString(context, (String)"bot");
        if (!BotCommand.BOT_INFO.map.containsKey(botName)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Bot %s is not found.".formatted(botName)));
            return 0;
        }
        if (!BotCommand.BOT_GROUP_INFO.map.containsKey(groupName)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Group %s is not found.".formatted(groupName)));
            return 0;
        }
        List<String> botNames = ((BotGroupInfo)BotCommand.BOT_GROUP_INFO.map.get((Object)groupName)).bots;
        if (botNames.contains(botName)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Bot %s is already added.".formatted(botName)));
            return 0;
        }
        botNames.add(botName);
        BotCommand.BOT_GROUP_INFO.map.put(groupName, new BotGroupInfo(groupName, botNames));
        BOT_GROUP_INFO.save();
        source.method_9226(() -> class_2561.method_43470((String)"Bot %s is added to %s successfully.".formatted(botName, groupName)), false);
        return 1;
    }

    private static int groupGenerated(CommandContext<class_2168> context) {
        BOT_INFO.init(context);
        BOT_GROUP_INFO.init(context);
        class_2168 source = (class_2168)context.getSource();
        String groupName = StringArgumentType.getString(context, (String)"name");
        int groupCount = IntegerArgumentType.getInteger(context, (String)"count");
        boolean groupLoad = BoolArgumentType.getBool(context, (String)"load");
        if (BotCommand.BOT_GROUP_INFO.map.containsKey(groupName)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Group %s already exists.".formatted(groupName)));
            return 0;
        }
        BotGroupInfo groupInfo = new BotGroupInfo(groupName, new ArrayList<String>());
        BotCommand.BOT_GROUP_INFO.map.put(groupName, groupInfo);
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Command source must be player."));
            return 0;
        }
        int result = 0;
        for (int i = 0; i < groupCount; ++i) {
            String botName = "bot_%s_%s".formatted(groupName, i);
            if (BotCommand.BOT_INFO.map.containsKey(botName)) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Bot %s already exists.".formatted(botName)));
                continue;
            }
            BotCommand.BOT_INFO.map.put(botName, new BotInfo(botName, botName, player.method_73189(), player.method_5802(), (class_5321<class_1937>)player.method_51469().method_27983(), player.field_13974.method_14257(), player.method_31549().field_7479, FakePlayerSerializer.actionPackToJson(new EntityPlayerActionPack(player))));
            List<String> botNames = groupInfo.bots;
            botNames.add(botName);
            ++result;
        }
        BOT_INFO.save();
        BOT_GROUP_INFO.save();
        if (groupLoad) {
            List<String> botNames = groupInfo.bots;
            for (String botName : new ArrayList<String>(botNames)) {
                if (!BotCommand.BOT_INFO.map.containsKey(botName)) continue;
                BotCommand.load(botName, arg_0 -> ((class_2168)source).method_9213(arg_0));
            }
        }
        source.method_9226(() -> class_2561.method_43470((String)"Group %s generated successfully.".formatted(groupName)), false);
        return result;
    }

    private static int groupCreate(CommandContext<class_2168> context) {
        BOT_GROUP_INFO.init(context);
        class_2168 source = (class_2168)context.getSource();
        String groupName = StringArgumentType.getString(context, (String)"name");
        if (BotCommand.BOT_GROUP_INFO.map.containsKey(groupName)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Group %s already exists.".formatted(groupName)));
            return 0;
        }
        BotCommand.BOT_GROUP_INFO.map.put(groupName, new BotGroupInfo(groupName, new ArrayList<String>()));
        BOT_GROUP_INFO.save();
        source.method_9226(() -> class_2561.method_43470((String)"Group %s created successfully.".formatted(groupName)), false);
        return 1;
    }

    private static int groupRemove(CommandContext<class_2168> context) {
        BOT_GROUP_INFO.init(context);
        String name = StringArgumentType.getString(context, (String)"name");
        BotGroupInfo remove = (BotGroupInfo)BotCommand.BOT_GROUP_INFO.map.remove(name);
        if (remove == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Bot Group %s is not exist.".formatted(name)));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"%s is removed.".formatted(name)), false);
        BOT_GROUP_INFO.save();
        return 1;
    }

    private static int groupList(CommandContext<class_2168> context) {
        int page;
        BOT_GROUP_INFO.init(context);
        try {
            page = IntegerArgumentType.getInteger(context, (String)"page");
        }
        catch (IllegalArgumentException ignored) {
            page = 1;
        }
        int pageSize = 8;
        int size = BotCommand.BOT_GROUP_INFO.map.size();
        int maxPage = size / 8 + 1;
        if (page > maxPage) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No such page %s".formatted(page)));
            return 0;
        }
        BotGroupInfo[] botGroupInfos = BotCommand.BOT_GROUP_INFO.map.values().toArray(new BotGroupInfo[0]);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"======= Bot Group List (Page %s/%s) =======".formatted(page, maxPage)).method_27692(class_124.field_1054));
        for (int i = (page - 1) * 8; i < size && i < page * 8; ++i) {
            ((class_2168)context.getSource()).method_45068((class_2561)BotCommand.botGroupToComponent(botGroupInfos[i]));
        }
        BotCommand.listComponent(context, page, maxPage, "/bot group list");
        return 1;
    }

    @NotNull
    private static class_5250 botGroupToComponent(@NotNull BotGroupInfo botGroupInfo) {
        class_5250 name = class_2561.method_43470((String)botGroupInfo.name).method_27696(class_2583.field_24360.method_27706(class_124.field_1080).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)botGroupInfo.name))));
        class_5250 load = class_2561.method_43470((String)"[\u2191]").method_27696(class_2583.field_24360.method_27706(class_124.field_1060).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)"Load Group"))).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, "/bot group load %s".formatted(botGroupInfo.name))));
        class_5250 remove = class_2561.method_43470((String)"[\u2193]").method_27696(class_2583.field_24360.method_27706(class_124.field_1061).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)"Unload Group"))).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, "/bot group unload %s".formatted(botGroupInfo.name))));
        class_5250 info = class_2561.method_43470((String)"[i]").method_27696(class_2583.field_24360.method_27706(class_124.field_1061).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)"Group Info"))).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, "/bot group info %s".formatted(botGroupInfo.name))));
        class_5250 delete = class_2561.method_43470((String)"[\ud83d\uddd1]").method_27696(class_2583.field_24360.method_27706(class_124.field_1061).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)"Remove Bot Group"))).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11745, "/bot group remove %s".formatted(botGroupInfo.name))));
        class_5250 component = class_2561.method_43470((String)"\u25b6 ").method_10852((class_2561)name);
        component.method_27693(" ").method_10852((class_2561)load);
        component.method_27693(" ").method_10852((class_2561)remove);
        component.method_27693(" ").method_10852((class_2561)info);
        return component.method_27693(" ").method_10852((class_2561)delete);
    }

    private static boolean load(String username, Consumer<class_2561> failure) {
        if (BotCommand.BOT_INFO.server.method_3760().method_14566(username) != null) {
            failure.accept((class_2561)class_2561.method_43470((String)"player %s is already exist.".formatted(username)));
            return false;
        }
        BotInfo botInfo = BotCommand.BOT_INFO.map.getOrDefault(username, null);
        if (botInfo == null) {
            failure.accept((class_2561)class_2561.method_43470((String)"%s is not exist."));
            return false;
        }
        boolean success = false;
        try {
            class_11560 gameprofile;
            class_3218 worldIn = BotCommand.BOT_INFO.server.method_3847(botInfo.dimType);
            class_3312 profileCache = GameProfileHelper.getProfileCache(BotCommand.BOT_INFO.server);
            if (profileCache == null) {
                gameprofile = null;
            } else {
                profileCache.method_72367(true);
                gameprofile = profileCache.method_14515(username).orElse(null);
                profileCache.method_72367(BotCommand.BOT_INFO.server.method_3816() && BotCommand.BOT_INFO.server.method_3828());
            }
            if (gameprofile == null) {
                if (!CarpetSettings.allowSpawningOfflinePlayers) {
                    return false;
                }
                gameprofile = new class_11560(class_4844.method_43344((String)username), username);
            }
            GameProfileHelper.fetchGameProfile(BotCommand.BOT_INFO.server, gameprofile.comp_4422()).thenAcceptAsync(p -> {
                GameProfile current = p;
                if (worldIn == null) {
                    return;
                }
                EntityPlayerMPFake instance = EntityPlayerMPFake.respawnFake((MinecraftServer)BotCommand.BOT_INFO.server, (class_3218)worldIn, (GameProfile)current, (class_8791)class_8791.method_53821());
                instance.fixStartingPosition = () -> instance.method_5808(botInfo.pos.field_1352, botInfo.pos.field_1351, botInfo.pos.field_1350, botInfo.facing.field_1342, botInfo.facing.field_1343);
                BotCommand.BOT_INFO.server.method_3760().method_14570((class_2535)new FakeClientConnection(class_2598.field_11941), (class_3222)instance, new class_8792(current, 0, instance.method_53823(), false));
                instance.method_48105(worldIn, botInfo.pos.field_1352, botInfo.pos.field_1351, botInfo.pos.field_1350, Set.of(), botInfo.facing.field_1342, botInfo.facing.field_1343, true);
                instance.method_6033(20.0f);
                ((EntityInvoker)instance).invokerUnsetRemoved();
                class_1324 attribute = instance.method_5996(class_5134.field_47761);
                if (attribute != null) {
                    attribute.method_6192((double)0.6f);
                }
                instance.field_13974.method_30118(botInfo.mode);
                BotCommand.BOT_INFO.server.method_3760().method_14589((class_2596)new class_2726((class_1297)instance, (byte)(instance.field_6241 * 256.0f / 360.0f)), botInfo.dimType);
                BotCommand.BOT_INFO.server.method_3760().method_14589((class_2596)class_10264.method_64558((class_1297)instance), botInfo.dimType);
                instance.method_5841().method_12778(PlayerAccessor.getCustomisationData(), (Object)127);
                instance.method_31549().field_7479 = botInfo.flying;
                FakePlayerSerializer.applyActionPackFromJson(botInfo.actions, (class_3222)instance);
            }, (Executor)BotCommand.BOT_INFO.server);
            success = true;
        }
        catch (Exception e) {
            GcaExtension.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (!success) {
            failure.accept((class_2561)class_2561.method_43470((String)"%s is not loaded.".formatted(username)));
        }
        return success;
    }

    private static int load(CommandContext<class_2168> context) {
        BOT_INFO.init(context);
        class_2168 source = (class_2168)context.getSource();
        String name = StringArgumentType.getString(context, (String)"player");
        boolean success = BotCommand.load(name, arg_0 -> ((class_2168)source).method_9213(arg_0));
        return success ? 1 : 0;
    }

    private static int add(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 p;
        BOT_INFO.init(context);
        class_2168 source = (class_2168)context.getSource();
        class_3222 class_32222 = p = class_2186.method_9315(context, (String)"player");
        if (!(class_32222 instanceof EntityPlayerMPFake)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"%s is not a fake player.".formatted(p.method_7334().name())));
            return 0;
        }
        EntityPlayerMPFake player = (EntityPlayerMPFake)class_32222;
        String name = player.method_7334().name();
        if (BotCommand.BOT_INFO.map.containsKey(name)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"%s is already save.".formatted(name)));
            return 0;
        }
        BotCommand.BOT_INFO.map.put(name, new BotInfo(name, StringArgumentType.getString(context, (String)"desc"), player.method_73189(), player.method_5802(), (class_5321<class_1937>)player.method_51469().method_27983(), player.field_13974.method_14257(), player.method_31549().field_7479, FakePlayerSerializer.actionPackToJson(((ServerPlayerInterface)player).getActionPack())));
        BOT_INFO.save();
        source.method_9226(() -> class_2561.method_43470((String)"%s is added.".formatted(name)), false);
        return 1;
    }

    private static int remove(CommandContext<class_2168> context) {
        BOT_INFO.init(context);
        String name = StringArgumentType.getString(context, (String)"player");
        BotInfo remove = (BotInfo)BotCommand.BOT_INFO.map.remove(name);
        if (remove == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Bot %s is not exist.".formatted(name)));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"%s is removed.".formatted(name)), false);
        BOT_INFO.save();
        return 1;
    }

    private static int list(CommandContext<class_2168> context) {
        int page;
        BOT_INFO.init(context);
        try {
            page = IntegerArgumentType.getInteger(context, (String)"page");
        }
        catch (IllegalArgumentException ignored) {
            page = 1;
        }
        int pageSize = 8;
        int size = BotCommand.BOT_INFO.map.size();
        int maxPage = size / 8 + 1;
        if (page > maxPage) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No such page %s".formatted(page)));
            return 0;
        }
        BotInfo[] botInfos = BotCommand.BOT_INFO.map.values().toArray(new BotInfo[0]);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"======= Bot List (Page %s/%s) =======".formatted(page, maxPage)).method_27692(class_124.field_1054));
        for (int i = (page - 1) * 8; i < size && i < page * 8; ++i) {
            ((class_2168)context.getSource()).method_45068((class_2561)BotCommand.botToComponent(botInfos[i]));
        }
        BotCommand.listComponent(context, page, maxPage, "/bot list");
        return 1;
    }

    @NotNull
    private static class_5250 botToComponent(@NotNull BotInfo botInfo) {
        class_5250 desc = class_2561.method_43470((String)botInfo.desc).method_27696(class_2583.field_24360.method_27706(class_124.field_1080).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)botInfo.name))));
        boolean notOnline = BotCommand.BOT_INFO.server.method_3760().method_14566(botInfo.name) == null;
        class_5250 load = class_2561.method_43470((String)"[\u2191]").method_27696(class_2583.field_24360.method_27706(notOnline ? class_124.field_1060 : class_124.field_1080).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)"Load bot"))).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, "/bot load %s".formatted(botInfo.name))));
        class_5250 remove = class_2561.method_43470((String)"[\u2193]").method_27696(class_2583.field_24360.method_27706(notOnline ? class_124.field_1080 : class_124.field_1061).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)"Unload bot"))).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, "/player %s kill".formatted(botInfo.name))));
        class_5250 delete = class_2561.method_43470((String)"[\ud83d\uddd1]").method_27696(class_2583.field_24360.method_27706(class_124.field_1061).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)"Remove bot"))).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11745, "/bot remove %s".formatted(botInfo.name))));
        class_5250 component = class_2561.method_43470((String)"\u25b6 ").method_27692(notOnline ? class_124.field_1061 : class_124.field_1060).method_10852((class_2561)desc);
        component.method_27693(" ").method_10852((class_2561)load);
        component.method_27693(" ").method_10852((class_2561)remove);
        return component.method_27693(" ").method_10852((class_2561)delete);
    }

    private static void listComponent(@NotNull CommandContext<class_2168> context, int page, int maxPage, String command) {
        class_5250 prevPage = page <= 1 ? class_2561.method_43470((String)"<<<").method_27692(class_124.field_1080) : class_2561.method_43470((String)"<<<").method_27696(class_2583.field_24360.method_27706(class_124.field_1060).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, command + " " + (page - 1))));
        class_5250 nextPage = page >= maxPage ? class_2561.method_43470((String)">>>").method_27692(class_124.field_1080) : class_2561.method_43470((String)">>>").method_27696(class_2583.field_24360.method_27706(class_124.field_1060).method_10958(ComponentUtils.createClickEvent(class_2558.class_2559.field_11750, command + " " + (page + 1))));
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"=======").method_27692(class_124.field_1054).method_27693(" ").method_10852((class_2561)prevPage).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)"(Page %s/%s)".formatted(page, maxPage)).method_27692(class_124.field_1054)).method_27693(" ").method_10852((class_2561)nextPage).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)"=======").method_27692(class_124.field_1054)));
    }

    @NotNull
    private static CompletableFuture<Suggestions> suggestPlayer(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(BotCommand.BOT_INFO.map.keySet(), (SuggestionsBuilder)builder);
    }

    @NotNull
    private static CompletableFuture<Suggestions> suggestGroup(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(BotCommand.BOT_GROUP_INFO.map.keySet(), (SuggestionsBuilder)builder);
    }

    public record BotGroupInfo(String name, List<String> bots) {
    }

    public record BotInfo(String name, String desc, class_243 pos, class_241 facing, @SerializedName(value="dim_type") class_5321<class_1937> dimType, class_1934 mode, boolean flying, JsonObject actions) {
    }
}

