/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.gugle.carpet.commands;

import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.dubhe.gugle.carpet.GcaSetting;
import dev.dubhe.gugle.carpet.commands.WlistCommand;
import dev.dubhe.gugle.carpet.tools.FilesUtil;
import dev.dubhe.gugle.carpet.tools.GameProfileHelper;
import dev.dubhe.gugle.carpet.tools.ModCommands;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_11560;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3335;
import net.minecraft.class_3336;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class BlistCommand {
    private static final SimpleCommandExceptionType ERROR_ALREADY_BANNED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.ban.failed"));
    private static final SimpleCommandExceptionType ERROR_NOT_BANNED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.pardon.failed"));
    public static final FilesUtil.MapFile<String, Boolean> PERMISSION = new FilesUtil.MapFile<String, Boolean>("blist", Object::toString, Boolean.class);

    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.root(dispatcher, "blist").requires(stack -> CommandHelper.canUseCommand((class_2168)stack, (Object)GcaSetting.commandBlist) && WlistCommand.hasPermission(PERMISSION, stack))).executes(BlistCommand::list)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"permission").requires(stack -> stack.method_9259(2))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).executes(BlistCommand::permissionAdd)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).executes(BlistCommand::permissionRemove))))).then(class_2170.method_9247((String)"add").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).executes(BlistCommand::add)).then(class_2170.method_9244((String)"reson", (ArgumentType)StringArgumentType.greedyString()).executes(BlistCommand::add))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).suggests((commandContext, suggestionsBuilder) -> class_2172.method_9253((String[])((class_2168)commandContext.getSource()).method_9211().method_3760().method_14563().method_14636(), (SuggestionsBuilder)suggestionsBuilder)).executes(BlistCommand::remove))));
    }

    public static int add(@NotNull CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3335 userBanList = source.method_9211().method_3760().method_14563();
        AtomicInteger i = new AtomicInteger();
        class_5250 component = null;
        try {
            component = class_2561.method_43470((String)StringArgumentType.getString(context, (String)"reson"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        class_5250 finalComponent = component;
        GameProfileHelper.praseGameProfileCollection(context, "targets", (arg_0, arg_1, arg_2) -> BlistCommand.lambda$add$4(userBanList, source, (class_2561)finalComponent, i, arg_0, arg_1, arg_2));
        if (i.get() == 0) {
            throw ERROR_ALREADY_BANNED.create();
        }
        return i.get();
    }

    public static int remove(@NotNull CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3335 userBanList = source.method_9211().method_3760().method_14563();
        AtomicInteger i = new AtomicInteger();
        GameProfileHelper.praseGameProfileCollection(context, "targets", (gameProfile, name, id) -> {
            if (userBanList.method_14650(gameProfile) && userBanList.method_14650(gameProfile)) {
                userBanList.method_74007(gameProfile);
                i.incrementAndGet();
                source.method_9226(() -> class_2561.method_43469((String)"commands.pardon.success", (Object[])new Object[]{class_2561.method_43470((String)name)}), true);
            }
        });
        if (i.get() == 0) {
            throw ERROR_NOT_BANNED.create();
        }
        return i.get();
    }

    public static int list(@NotNull CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        Collection collection = source.method_9211().method_3760().method_14563().method_14632();
        if (collection.isEmpty()) {
            source.method_9226(() -> class_2561.method_43471((String)"commands.banlist.none"), false);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"commands.banlist.list", (Object[])new Object[]{collection.size()}), false);
            for (class_3336 userBanListEntry : collection) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.banlist.entry", (Object[])new Object[]{userBanListEntry.method_14504(), userBanListEntry.method_14501(), userBanListEntry.method_14503()}), false);
            }
        }
        return collection.size();
    }

    private static int permissionAdd(CommandContext<class_2168> context) throws CommandSyntaxException {
        PERMISSION.init(context);
        AtomicInteger i = new AtomicInteger();
        GameProfileHelper.praseGameProfileCollection(context, "targets", (gameProfile, name, id) -> {
            BlistCommand.PERMISSION.map.put(id.toString(), true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Player %s has been granted permission to operate the banned list.".formatted(name)), true);
            i.incrementAndGet();
        });
        PERMISSION.save();
        return i.get();
    }

    private static int permissionRemove(CommandContext<class_2168> context) throws CommandSyntaxException {
        PERMISSION.init(context);
        AtomicInteger i = new AtomicInteger();
        GameProfileHelper.praseGameProfileCollection(context, "targets", (gameProfile, name, id) -> {
            BlistCommand.PERMISSION.map.put(id.toString(), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Revoked player %s's permission to operate the banned list".formatted(name)), true);
            i.incrementAndGet();
        });
        PERMISSION.save();
        return i.get();
    }

    private static /* synthetic */ void lambda$add$4(class_3335 userBanList, class_2168 source, class_2561 finalComponent, AtomicInteger i, class_11560 gameProfile, String name, UUID id) {
        if (!userBanList.method_14650(gameProfile)) {
            class_3336 userBanListEntry = new class_3336(gameProfile, null, source.method_9214(), null, finalComponent == null ? null : finalComponent.getString());
            userBanList.method_74006(userBanListEntry);
            i.incrementAndGet();
            source.method_9226(() -> class_2561.method_43469((String)"commands.ban.success", (Object[])new Object[]{class_2561.method_43470((String)name), userBanListEntry.method_14503()}), true);
            class_3222 serverPlayer = source.method_9211().method_3760().method_14602(id);
            if (serverPlayer != null) {
                serverPlayer.field_13987.method_52396((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.banned"));
            }
        }
    }
}

