/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.gugle.carpet.tools;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.dubhe.gugle.carpet.GcaExtension;
import dev.dubhe.gugle.carpet.tools.ComponentUtils;
import dev.dubhe.gugle.carpet.tools.FilesUtil;
import dev.dubhe.gugle.carpet.tools.GameProfileHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.time.DateUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WelcomeMessage {
    public static final String ARGS_REGEX = "\\{%\\w+%}";
    public static final FilesUtil.ObjFile<MessageConfig> WELCOME_MESSAGE = new FilesUtil.ObjFile<MessageConfig>("welcome", new MessageConfig());

    public static void onPlayerLoggedIn(@NotNull class_3222 player) {
        MessageConfig config = (MessageConfig)WelcomeMessage.WELCOME_MESSAGE.obj;
        MinecraftServer server = GameProfileHelper.getServerPlayerServer(player);
        for (String msg : config.message) {
            ArrayList<String> argKeys = new ArrayList<String>();
            Matcher matcher = Pattern.compile(ARGS_REGEX).matcher(msg);
            while (matcher.find()) {
                argKeys.add(msg.substring(matcher.start() + 2, matcher.end() - 2));
            }
            ArrayList<String> split = new ArrayList<String>(List.of(msg.split(ARGS_REGEX)));
            List<MessageData> args = argKeys.stream().map(config::getArg).toList();
            for (int i = split.size(); i < args.size() + 1; ++i) {
                split.add("");
            }
            class_5250 component = class_2561.method_43470((String)"").method_27692(class_124.field_1068);
            for (int i = 0; i < split.size(); ++i) {
                component.method_27693((String)split.get(i));
                if (i >= args.size()) continue;
                MessageData messageData = args.get(i);
                component.method_10852((class_2561)messageData.getMsg(server, player).method_27692(messageData.color));
            }
            player.method_43496((class_2561)component);
        }
    }

    public static class MessageConfig {
        public List<String> message = new ArrayList<String>();
        public Map<String, MessageData> args = new HashMap<String, MessageData>();

        public MessageConfig() {
            this.message.add("{%player%}, welcome!");
            this.args.put("player", new MessageData());
        }

        public MessageData getArg(String key) {
            return this.args.getOrDefault(key, new MessageData());
        }
    }

    public static class MessageData {
        public class_2960 type;
        public JsonElement data;
        public class_124 color;

        public MessageData() {
            this.type = MessageDataType.PLAYER.location;
            this.data = null;
            this.color = class_124.field_1065;
        }

        public MessageDataType getType() {
            return MessageDataType.get(this.type);
        }

        public class_5250 getMsg(MinecraftServer server, class_3222 player) {
            return this.getType().getMsg(server, player, this.data);
        }

        public static class Serializer
        implements JsonSerializer<MessageData>,
        JsonDeserializer<MessageData> {
            public MessageData deserialize(@NotNull JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                MessageData data = new MessageData();
                if (json.isJsonPrimitive()) {
                    data.type = MessageDataType.get((class_2960)GcaExtension.parseLocation((String)json.getAsString())).location;
                    return data;
                }
                JsonObject object = json.getAsJsonObject();
                if (object.has("type")) {
                    data.type = MessageDataType.get((class_2960)GcaExtension.parseLocation((String)object.get((String)"type").getAsString())).location;
                }
                if (object.has("data")) {
                    data.data = object.get("data");
                }
                if (object.has("color")) {
                    data.color = class_124.method_533((String)object.get("color").getAsString());
                }
                return data;
            }

            public JsonElement serialize(@NotNull MessageData src, Type typeOfSrc, JsonSerializationContext context) {
                if (src.color == class_124.field_1065 && src.data == null) {
                    return new JsonPrimitive(src.type.toString());
                }
                JsonObject object = new JsonObject();
                object.addProperty("type", src.type.toString());
                if (src.data != null) {
                    object.add("data", src.data);
                }
                if (src.color != class_124.field_1065) {
                    object.addProperty("color", src.color.toString());
                }
                return object;
            }
        }
    }

    public static enum MessageDataType implements WelcomeMessageFunction
    {
        NONE(GcaExtension.id("none"), (s, p, d) -> class_2561.method_43470((String)"")),
        PLAYER(GcaExtension.id("player"), (s, p, d) -> {
            class_5250 component = class_2561.method_43470((String)"");
            GameProfileHelper.prasePlayerGameProfile(p, (profile, name, uuid) -> component.method_27693(name));
            return component;
        }),
        DAYCOUNT(GcaExtension.id("day_count"), (s, p, d) -> {
            class_5250 component = class_2561.method_43470((String)String.valueOf(s.method_30002().method_8532() / 1728000L));
            if (d == null || d.isJsonNull() || !d.isJsonPrimitive() && !d.isJsonObject() || d.isJsonObject() && d.getAsJsonObject().asMap().isEmpty()) {
                return component;
            }
            String fromDay = "";
            if (d.isJsonPrimitive()) {
                fromDay = d.getAsString();
            } else if (d.isJsonObject()) {
                fromDay = d.getAsJsonObject().getAsJsonPrimitive("from").getAsString();
            }
            if (fromDay.isEmpty()) {
                return component;
            }
            Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC+8"));
            date.setTime(DateUtils.parseDate((String)fromDay, (Locale)Locale.CHINA, (String[])new String[]{"yyyy-MM-dd"}));
            Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC+8"));
            if (now.getTimeInMillis() - date.getTimeInMillis() >= 0L) {
                return class_2561.method_43470((String)String.valueOf((now.getTimeInMillis() - date.getTimeInMillis()) / 86400000L + 1L));
            }
            return component;
        }),
        RANDOM(GcaExtension.id("random"), (s, p, d) -> {
            ArrayList<String> args = new ArrayList<String>();
            if (d != null && d.isJsonArray()) {
                for (JsonElement element : d.getAsJsonArray()) {
                    if (!element.isJsonPrimitive()) continue;
                    args.add(element.getAsString());
                }
            }
            return class_2561.method_43470((String)((String)args.get(new Random().nextInt(args.size()))));
        }),
        SERVER(GcaExtension.id("server"), (s, p, d) -> {
            class_5250 component = class_2561.method_43470((String)"").method_27692(class_124.field_1068);
            if (d == null || !d.isJsonArray()) {
                return component;
            }
            int i = 0;
            for (JsonElement element : d.getAsJsonArray()) {
                String host;
                String name;
                if (!element.isJsonPrimitive() && !element.isJsonObject()) continue;
                if (element.isJsonPrimitive()) {
                    name = "[Server]";
                    host = element.getAsString();
                } else {
                    JsonObject object = element.getAsJsonObject();
                    name = object.has("name") ? "[%s]".formatted(object.get("name").getAsString()) : "[Server]";
                    host = object.has("host") ? object.get("host").getAsString() : "";
                }
                class_5250 component1 = class_2561.method_43470((String)name);
                class_2583 style = class_2583.field_24360.method_27706(class_124.field_1060).method_10949(ComponentUtils.createHoverEvent(class_2568.class_5247.field_24342, class_2561.method_43470((String)host)));
                component1.method_10862(style);
                component.method_10852((class_2561)component1);
                if (i != d.getAsJsonArray().size() - 1) {
                    component.method_10852((class_2561)class_2561.method_43470((String)" "));
                }
                ++i;
            }
            return class_2561.method_43470((String)"").method_10852((class_2561)component);
        });

        public final class_2960 location;
        private final WelcomeMessageFunction function;

        private MessageDataType(class_2960 location, WelcomeMessageFunction function) {
            this.location = location;
            this.function = function;
        }

        @NotNull
        public String toString() {
            return this.location.toString();
        }

        public static MessageDataType get(class_2960 location) {
            for (MessageDataType value : MessageDataType.values()) {
                if (!value.location.equals((Object)location)) continue;
                return value;
            }
            return NONE;
        }

        @Override
        public class_5250 getMsg(@NotNull MinecraftServer server, @NotNull class_3222 player, @Nullable JsonElement data) {
            try {
                return this.function.getMsg(server, player, data);
            }
            catch (Exception e) {
                GcaExtension.LOGGER.error(e.getMessage(), (Throwable)e);
                return class_2561.method_43470((String)"");
            }
        }
    }

    @FunctionalInterface
    public static interface WelcomeMessageFunction {
        public class_5250 getMsg(@NotNull MinecraftServer var1, @NotNull class_3222 var2, @Nullable JsonElement var3) throws Exception;
    }
}

