/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.bbllights.event;

import com.benbenlaw.bbllights.item.BBLLightsDataComponents;
import com.benbenlaw.bbllights.item.LightItem;
import com.benbenlaw.bbllights.network.LightItemPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import org.joml.Quaternionfc;

@EventBusSubscriber(modid="bbllights", value={Dist.CLIENT})
public class LightBlocksEmitLightEvent {
    private static final List<BlockPos> lightBlockPositions = new ArrayList<BlockPos>();
    public static int particleDelay = 0;

    @SubscribeEvent
    public static void onClientPlayerTickEvent(ClientTickEvent.Post event) {
        if (++particleDelay < 20) {
            return;
        }
        particleDelay = 0;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null || minecraft.level == null) {
            return;
        }
        ItemStack lightItem = Minecraft.getInstance().player.getMainHandItem();
        ClientLevel level = Minecraft.getInstance().level;
        if (lightItem.getItem() instanceof LightItem) {
            BlockPos playerPos = Minecraft.getInstance().player.blockPosition();
            int radius = 32;
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)playerPos.offset(-radius, -radius, -radius), (BlockPos)playerPos.offset(radius, radius, radius))) {
                assert (level != null);
                if (!level.getBlockState(pos).is(Blocks.LIGHT)) continue;
                lightBlockPositions.add(pos);
                double x = (double)pos.getX() + 0.5;
                double y = (double)pos.getY() + 0.5;
                double z = (double)pos.getZ() + 0.5;
                level.addParticle((ParticleOptions)ParticleTypes.END_ROD, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    @SubscribeEvent
    public static void onClientWorldRender(RenderLevelStageEvent.AfterTranslucentBlocks event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        ItemStack lightItem = mc.player.getMainHandItem();
        if (!(lightItem.getItem() instanceof LightItem)) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Font font = mc.font;
        BlockPos playerPos = mc.player.blockPosition();
        int radius = 16;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)playerPos.offset(-radius, -radius, -radius), (BlockPos)playerPos.offset(radius, radius, radius))) {
            BlockState state = mc.level.getBlockState(pos);
            if (!state.is(Blocks.LIGHT)) continue;
            int lightLevel = (Integer)state.getValue((Property)LightBlock.LEVEL);
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.75;
            double z = (double)pos.getZ() + 0.5;
            poseStack.pushPose();
            poseStack.translate(x - mc.getEntityRenderDispatcher().camera.getPosition().x, y - mc.getEntityRenderDispatcher().camera.getPosition().y, z - mc.getEntityRenderDispatcher().camera.getPosition().z);
            poseStack.mulPose((Quaternionfc)mc.getEntityRenderDispatcher().camera.rotation());
            poseStack.scale(0.02f, -0.02f, 0.02f);
            float width = (float)font.width(String.valueOf(lightLevel)) / 2.0f;
            font.drawInBatch(String.valueOf(lightLevel), -width, 0.0f, -1, false, poseStack.last().pose(), (MultiBufferSource)mc.renderBuffers().bufferSource(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            poseStack.popPose();
        }
        mc.renderBuffers().bufferSource().endBatch();
    }

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        ItemStack stack = mc.player.getMainHandItem();
        if (stack.getItem() instanceof LightItem && mc.player.isShiftKeyDown()) {
            int lightLevel = (Integer)stack.getOrDefault((DataComponentType)BBLLightsDataComponents.LIGHT_LEVEL.get(), (Object)15);
            boolean changed = false;
            if (event.getScrollDeltaY() > 0.0 && lightLevel < 15) {
                ++lightLevel;
                changed = true;
            } else if (event.getScrollDeltaY() < 0.0 && lightLevel > 0) {
                --lightLevel;
                changed = true;
            }
            if (changed) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new LightItemPacket(lightLevel), (CustomPacketPayload[])new CustomPacketPayload[0]);
                stack.set(BBLLightsDataComponents.LIGHT_LEVEL, (Object)lightLevel);
                mc.gui.setOverlayMessage((Component)Component.translatable((String)"tooltip.core.light_level", (Object[])new Object[]{lightLevel}), false);
                event.setCanceled(true);
            }
        }
    }
}

