/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.bbllights.item;

import com.benbenlaw.bbllights.item.BBLLightsDataComponents;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class LightItem
extends Item {
    public LightItem(Item.Properties properties) {
        super(properties.component(BBLLightsDataComponents.LIGHT_LEVEL, (Object)15));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        EquipmentSlot slot;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockPos lightPos = pos.relative(direction);
        InteractionHand hand = context.getHand();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack litItem = player.getItemInHand(hand);
        int lightLevel = (Integer)litItem.getOrDefault((DataComponentType)BBLLightsDataComponents.LIGHT_LEVEL.get(), (Object)15);
        EquipmentSlot equipmentSlot = slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        if (!level.isClientSide()) {
            BlockState current = level.getBlockState(lightPos);
            if (current.is(Blocks.LIGHT)) {
                level.removeBlock(lightPos, false);
            } else {
                level.setBlockAndUpdate(lightPos, (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(lightLevel)));
                if (litItem.isDamageableItem()) {
                    litItem.hurtAndBreak(1, (LivingEntity)player, slot);
                } else {
                    litItem.shrink(1);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag flag) {
        int lightLevel = (Integer)stack.getOrDefault((DataComponentType)BBLLightsDataComponents.LIGHT_LEVEL.get(), (Object)15);
        if (Screen.hasShiftDown()) {
            componentConsumer.accept((Component)Component.translatable((String)"tooltip.bbllights.light_level", (Object[])new Object[]{lightLevel}).copy().withStyle(ChatFormatting.YELLOW));
        } else {
            componentConsumer.accept((Component)Component.translatable((String)"tooltips.bbllights.shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

