/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.GeneralConfig;
import com.tristankechlo.livingthings.config.entity.AncientBlazeConfig;
import com.tristankechlo.livingthings.entity.ai.AncientBlazeChargeUpGoal;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1370;
import net.minecraft.class_1376;
import net.minecraft.class_1381;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1542;
import net.minecraft.class_1545;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1674;
import net.minecraft.class_1677;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import net.minecraft.class_8103;

public class AncientBlazeEntity
extends class_1588
implements class_1603,
ILexiconEntry {
    private static final class_2940<Byte> SHOOTS = class_2945.method_12791(AncientBlazeEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> INVULNERABLE_TIME = class_2945.method_12791(AncientBlazeEntity.class, (class_2941)class_2943.field_13327);
    private final class_3213 bossInfo = new class_3213(this.method_5476(), class_1259.class_1260.field_5782, class_1259.class_1261.field_5795);

    public AncientBlazeEntity(class_1299<? extends AncientBlazeEntity> type, class_1937 world) {
        super(type, world);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_14, 8.0f);
        this.method_5941(class_7.field_9, 0.0f);
        this.method_5941(class_7.field_3, 0.0f);
        this.field_6194 = 30;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, AncientBlazeConfig.health()).method_26868(class_5134.field_23719, AncientBlazeConfig.movementSpeed()).method_26868(class_5134.field_23717, 48.0).method_26868(class_5134.field_23721, AncientBlazeConfig.attackDamage());
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn) {
        this.setInvulnerableTime(AncientBlazeConfig.chargingTime());
        return super.method_5943(worldIn, difficultyIn, reason, spawnDataIn);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new AncientBlazeChargeUpGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1381((class_1603)this, 1.0, 30, 20.0f));
        this.field_6201.method_6277(2, (class_1352)new class_1370((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true, true));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(INVULNERABLE_TIME, (Object)0);
        builder.method_56912(SHOOTS, (Object)0);
    }

    public void method_5652(class_11372 compound) {
        super.method_5652(compound);
        compound.method_71465("ChargedTime", this.getInvulnerableTime());
        compound.method_71462("Shoots", this.getShoots());
    }

    public void method_5749(class_11368 compound) {
        super.method_5749(compound);
        this.setInvulnerableTime(compound.method_71424("ChargedTime", 0));
        this.setShoots(compound.method_71421("Shoots", (byte)0));
        if (this.method_16914()) {
            this.bossInfo.method_5413(this.method_5476());
        }
    }

    public void method_5665(class_2561 name) {
        super.method_5665(name);
        this.bossInfo.method_5413(this.method_5476());
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_73183().method_8316(this.method_24515()).method_15767(class_3486.field_15517) || this.method_73183().method_8316(this.method_24515()).method_15767(class_3486.field_15518)) {
            this.method_18799(this.method_18798().method_1021(0.5).method_1031(0.0, 0.05, 0.0));
        }
    }

    public void method_6007() {
        if (!this.method_24828() && this.method_18798().field_1351 < 0.0) {
            this.method_18799(this.method_18798().method_18805(1.0, 0.6, 1.0));
        }
        if (this.method_73183().method_8608() && this.getInvulnerableTime() == 0) {
            if (this.field_5974.method_43048(24) == 0 && !this.method_5701()) {
                this.method_73183().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.ANCIENT_BLAZE_BURN.get(), this.method_5634(), 1.0f + this.field_5974.method_43057(), this.field_5974.method_43057() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.method_73183().method_8406((class_2394)class_2398.field_11237, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.method_6007();
    }

    protected void method_5958(class_3218 level) {
        super.method_5958(level);
        this.bossInfo.method_5408(this.method_6032() / this.method_6063());
    }

    protected void method_6099(class_3218 level, class_1282 source, boolean recentlyHitIn) {
        super.method_6099(level, source, recentlyHitIn);
        class_1542 itementity = this.method_5706(level, (class_1935)ModItems.ANCIENT_HELMET.get());
        if (itementity != null) {
            itementity.method_6976();
        }
    }

    protected class_3414 method_5994() {
        return ModSounds.ANCIENT_BLAZE_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return ModSounds.ANCIENT_BLAZE_HURT.get();
    }

    protected class_3414 method_6002() {
        return ModSounds.ANCIENT_BLAZE_DEATH.get();
    }

    public boolean method_64397(class_3218 level, class_1282 source, float amount) {
        if (this.getInvulnerableTime() > 0 && !source.method_48789(class_8103.field_42242)) {
            return false;
        }
        if (source.method_5526() instanceof class_1674 && source.method_5529() instanceof class_1657) {
            byte shoots = this.getShoots();
            if (shoots < AncientBlazeConfig.largeFireballAmount()) {
                this.setShoots((byte)(shoots + 1));
                return false;
            }
            return true;
        }
        if (!source.method_60489()) {
            return this.field_5974.method_43048(4) != 0 && super.method_64397(level, source, amount);
        }
        return super.method_64397(level, source, amount);
    }

    public void method_7105(class_1309 target, float distanceFactor) {
        boolean peaceful = this.method_73183().method_8407() == class_1267.field_5801;
        boolean ambientMode = GeneralConfig.get().ambientMode.get();
        if (peaceful || ambientMode || !AncientBlazeConfig.canAttack()) {
            return;
        }
        double d1 = target.method_23317() - this.method_23317();
        double d2 = target.method_23323(0.5) - this.method_23323(0.5);
        double d3 = target.method_23321() - this.method_23321();
        byte shoots = this.getShoots();
        double chance = (double)AncientBlazeConfig.largeFireballChance() / 100.0;
        if (this.field_5974.method_43058() < chance && shoots > 0) {
            this.setShoots((byte)(shoots - 1));
            class_1674 fireballentity = new class_1674(this.method_73183(), (class_1309)this, new class_243(d1, d2, d3), 1);
            fireballentity.method_5814(fireballentity.method_23317(), this.method_23323(0.5) + 0.5, fireballentity.method_23321());
            this.method_73183().method_8649((class_1297)fireballentity);
        } else {
            class_1677 smallfireballentity = new class_1677(this.method_73183(), (class_1309)this, new class_243(d1, d2, d3));
            smallfireballentity.method_5814(smallfireballentity.method_23317(), this.method_23323(0.5) + 0.5, smallfireballentity.method_23321());
            this.method_73183().method_8649((class_1297)smallfireballentity);
        }
        if (!this.method_73183().method_8608()) {
            this.method_73183().method_8396(null, this.method_24515(), ModSounds.ANCIENT_BLAZE_SHOOT.get(), class_3419.field_15251, 2.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        }
    }

    public void method_5650(class_1297.class_5529 reason) {
        int amount = AncientBlazeConfig.blazeSpawnCount();
        if (!this.method_73183().method_8608() && amount >= 1 && this.method_29504()) {
            for (int i = 0; i < amount; ++i) {
                class_1545 blaze = new class_1545(class_1299.field_6099, this.method_73183());
                if (this.method_5947()) {
                    blaze.method_5971();
                }
                blaze.method_5665(this.method_5797());
                blaze.method_5977(this.method_5987());
                blaze.method_5684(this.method_5655());
                blaze.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.field_5974.method_43057() * 360.0f, 0.0f);
                this.method_73183().method_8649((class_1297)blaze);
            }
        }
        super.method_5650(reason);
    }

    public float method_5718() {
        return 1.0f;
    }

    public void method_5982() {
        if (this.method_73183().method_8407() == class_1267.field_5801 && AncientBlazeConfig.peacefulDespawn()) {
            this.method_31472();
        }
        super.method_5982();
    }

    public boolean method_29503() {
        return true;
    }

    public boolean method_5809() {
        return false;
    }

    public boolean method_5747(double p_397597_, float p_147187_, class_1282 p_147189_) {
        return false;
    }

    public boolean method_6101() {
        return false;
    }

    public int method_5945() {
        return 1;
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossInfo.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossInfo.method_14089(player);
    }

    public int getInvulnerableTime() {
        return (Integer)this.field_6011.method_12789(INVULNERABLE_TIME);
    }

    public void setInvulnerableTime(int time) {
        this.field_6011.method_12778(INVULNERABLE_TIME, (Object)time);
    }

    public byte getShoots() {
        return (Byte)this.field_6011.method_12789(SHOOTS);
    }

    public void setShoots(byte shoots) {
        this.field_6011.method_12778(SHOOTS, (Object)shoots);
    }

    public boolean isPowered() {
        return (Integer)this.field_6011.method_12789(INVULNERABLE_TIME) > 0;
    }

    @Override
    public class_2960 getLexiconEntry() {
        return LexiconEntries.ANCIENT_BLAZE;
    }

    public boolean method_26319(class_3610 state) {
        return state.method_15767(class_3486.field_15517) || state.method_15767(class_3486.field_15518);
    }
}

