/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.block.OstrichNestBlock;
import com.tristankechlo.livingthings.config.entity.OstrichConfig;
import com.tristankechlo.livingthings.entity.ai.OstrichBreedGoal;
import com.tristankechlo.livingthings.init.ModBlocks;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import com.tristankechlo.livingthings.util.Predicates;
import net.minecraft.class_11;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1367;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4538;
import net.minecraft.class_4980;
import net.minecraft.class_4981;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;

public class OstrichEntity
extends class_1429
implements class_4981,
ILexiconEntry {
    private static final class_2940<Boolean> HAS_EGG = class_2945.method_12791(OstrichEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_BUILDING_NEST = class_2945.method_12791(OstrichEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_LAYING_EGG = class_2945.method_12791(OstrichEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SADDLED = class_2945.method_12791(OstrichEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> BOOST_TIME = class_2945.method_12791(OstrichEntity.class, (class_2941)class_2943.field_13327);
    private final class_4980 boostHelper;
    private int nestBuildingCounter;
    private int layingEggCounter;

    public OstrichEntity(class_1299<? extends OstrichEntity> entityType, class_1937 worldIn) {
        super(entityType, worldIn);
        this.boostHelper = new class_4980(this.field_6011, BOOST_TIME);
    }

    public static boolean checkOstrichSpawnRules(class_1299<OstrichEntity> animal, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(LivingThingsTags.OSTRICH_SPAWNABLE_ON) && OstrichEntity.method_39448((class_1920)world, (class_2338)pos);
    }

    public class_1296 method_5613(class_3218 world, class_1296 parent) {
        return (class_1296)ModEntityTypes.OSTRICH.get().method_5883((class_1937)world, class_3730.field_16466);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_52450, OstrichConfig.temptRange()).method_26868(class_5134.field_23716, OstrichConfig.health()).method_26868(class_5134.field_23719, OstrichConfig.movementSpeed());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.4));
        this.field_6201.method_6277(2, (class_1352)new OstrichBreedGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new LayEggGoal(this, 1.1));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.1, Predicates.OSTRICH_FOOD, false));
        this.field_6201.method_6277(5, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.3));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, OstrichEntity.class, 8.0f));
        this.field_6201.method_6277(9, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_EGG, (Object)false);
        builder.method_56912(IS_BUILDING_NEST, (Object)false);
        builder.method_56912(IS_LAYING_EGG, (Object)false);
        builder.method_56912(SADDLED, (Object)true);
        builder.method_56912(BOOST_TIME, (Object)0);
    }

    public void method_5652(class_11372 compound) {
        super.method_5652(compound);
        compound.method_71472("HasEgg", this.hasEgg());
    }

    public void method_5749(class_11368 compound) {
        super.method_5749(compound);
        this.setHasEgg(compound.method_71433("HasEgg", false));
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_5805() && this.isBuildingNest() && this.nestBuildingCounter >= 1 && this.nestBuildingCounter % 7 == 0) {
            class_2338 pos = this.method_24515();
            this.method_73183().method_20290(2001, pos, class_2248.method_9507((class_2680)class_2246.field_10102.method_9564()));
        }
    }

    public int method_5945() {
        return OstrichConfig.maxSpawnedInChunk();
    }

    public void method_5674(class_2940<?> key) {
        if (BOOST_TIME.equals(key) && this.method_73183().method_8608()) {
            this.boostHelper.method_26307();
        }
        super.method_5674(key);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(LivingThingsTags.OSTRICH_FOOD);
    }

    protected void method_16078(class_3218 level) {
        super.method_16078(level);
        if (this.hasEgg()) {
            this.method_5706(level, (class_1935)ModItems.OSTRICH_EGG.get());
        }
    }

    public boolean isBuildingNest() {
        return (Boolean)this.field_6011.method_12789(IS_BUILDING_NEST);
    }

    public void setBuildingNest(boolean building) {
        this.nestBuildingCounter = building ? 1 : 0;
        this.field_6011.method_12778(IS_BUILDING_NEST, (Object)building);
    }

    public boolean isLayingEgg() {
        return (Boolean)this.field_6011.method_12789(IS_LAYING_EGG);
    }

    public void setLayingEgg(boolean layingEgg) {
        this.layingEggCounter = layingEgg ? 1 : 0;
        this.field_6011.method_12778(IS_LAYING_EGG, (Object)layingEgg);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_6011.method_12789(HAS_EGG);
    }

    public void setHasEgg(boolean hasEgg) {
        this.field_6011.method_12778(HAS_EGG, (Object)hasEgg);
    }

    protected class_3414 method_5994() {
        return ModSounds.OSTRICH_AMBIENT.get();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        boolean isLexicon;
        boolean breedingItem = this.method_6481(player.method_5998(hand));
        boolean bl = isLexicon = player.method_6047().method_7909() == ModItems.LEXICON.get();
        if (!(breedingItem || isLexicon || this.method_5782() || this.method_6109() || player.method_21823())) {
            if (!this.method_73183().method_8608() && OstrichConfig.canBeRidden()) {
                player.method_5804((class_1297)this);
                return class_1269.field_52422;
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    public class_1309 method_5642() {
        class_1297 passenger = this.method_31483();
        if (passenger instanceof class_1657) {
            return (class_1657)passenger;
        }
        return null;
    }

    public boolean method_6577() {
        return this.boostHelper.method_26308(this.method_59922());
    }

    protected void method_49481(class_1657 player, class_243 vec3) {
        super.method_49481(player, vec3);
        this.method_5710(player.method_36454(), player.method_36455() * 0.5f);
        this.field_6283 = this.field_6241 = this.method_36454();
        this.field_5982 = this.field_6241;
        this.boostHelper.method_49478();
    }

    protected class_243 method_52533(class_1297 rider, class_4048 dimensions, float scale) {
        return new class_243(0.0, (double)(dimensions.comp_2186() * 0.7f * scale), 0.0);
    }

    protected class_243 method_49482(class_1657 player, class_243 travelVec) {
        return new class_243(0.0, 0.0, 1.0);
    }

    protected float method_49485(class_1657 player) {
        return (float)this.method_45325(class_5134.field_23719) * 0.9f;
    }

    @Override
    public class_2960 getLexiconEntry() {
        return LexiconEntries.OSTRICH;
    }

    private static class LayEggGoal
    extends class_1367 {
        private final OstrichEntity ostrich;
        private boolean isAboveDestination;

        public LayEggGoal(OstrichEntity creature, double speedIn) {
            super((class_1314)creature, speedIn, 16);
            this.ostrich = creature;
        }

        public boolean method_6264() {
            return (this.ostrich.hasEgg() || this.ostrich.isBuildingNest() || this.ostrich.isLayingEgg()) && super.method_6264();
        }

        public boolean method_6266() {
            return super.method_6266() && (this.ostrich.hasEgg() || this.ostrich.isBuildingNest() || this.ostrich.isLayingEgg());
        }

        protected void method_6290() {
            class_2338 blockpos = this.method_30953();
            class_11 path = this.field_6516.method_5942().method_6352((double)blockpos.method_10263() + 0.5, (double)blockpos.method_10264(), (double)blockpos.method_10260() + 0.5, 0);
            this.field_6516.method_5942().method_6334(path, this.field_6514);
        }

        protected class_2338 method_30953() {
            if (this.ostrich.method_73183().method_8320(this.field_6512).method_26204() == ModBlocks.OSTRICH_NEST.get()) {
                return this.field_6512;
            }
            return this.field_6512.method_10084();
        }

        public void method_6268() {
            class_2338 blockpos = this.method_30953();
            if (!blockpos.method_19769((class_2374)this.field_6516.method_73189(), this.method_6291())) {
                this.isAboveDestination = false;
                ++this.field_6517;
                if (this.method_6294()) {
                    class_11 path = this.field_6516.method_5942().method_6352((double)blockpos.method_10263() + 0.5, (double)blockpos.method_10264(), (double)blockpos.method_10260() + 0.5, 0);
                    this.field_6516.method_5942().method_6334(path, this.field_6514);
                }
            } else {
                this.isAboveDestination = true;
                --this.field_6517;
            }
            if (!this.ostrich.method_5799() && this.method_6295()) {
                class_1937 world = this.ostrich.method_73183();
                if (world.method_8320(this.field_6512).method_26204() == ModBlocks.OSTRICH_NEST.get()) {
                    class_2680 state = world.method_8320(this.field_6512);
                    if (!((Boolean)state.method_11654((class_2769)OstrichNestBlock.EGG)).booleanValue()) {
                        if (this.ostrich.layingEggCounter < 1) {
                            this.ostrich.setLayingEgg(true);
                        } else if (this.ostrich.layingEggCounter > 150) {
                            world.method_8396(null, this.field_6512, ModSounds.OSTRICH_EGG_LAYING.get(), class_3419.field_15245, 0.5f, 0.9f);
                            world.method_8652(this.field_6512, (class_2680)state.method_11657((class_2769)OstrichNestBlock.EGG, (Comparable)Boolean.valueOf(true)), 3);
                            this.ostrich.setHasEgg(false);
                            this.ostrich.setLayingEgg(false);
                        }
                        if (this.ostrich.isLayingEgg()) {
                            ++this.ostrich.layingEggCounter;
                        }
                    }
                } else {
                    if (this.ostrich.nestBuildingCounter < 1) {
                        this.ostrich.setBuildingNest(true);
                    } else if (this.ostrich.nestBuildingCounter > 100) {
                        world.method_8396(null, this.field_6512, class_3417.field_15173, class_3419.field_15245, 0.9f, 0.9f);
                        world.method_8652(this.field_6512.method_10084(), ModBlocks.OSTRICH_NEST.get().method_9564(), 3);
                        this.field_6512 = this.field_6512.method_10084();
                        this.ostrich.setBuildingNest(false);
                    }
                    if (this.ostrich.isBuildingNest()) {
                        ++this.ostrich.nestBuildingCounter;
                    }
                }
            } else {
                this.ostrich.setLayingEgg(false);
                this.ostrich.setBuildingNest(false);
            }
        }

        public void method_6270() {
            super.method_6270();
            this.ostrich.setLayingEgg(false);
            this.ostrich.setBuildingNest(false);
        }

        protected boolean method_6295() {
            return this.isAboveDestination;
        }

        protected boolean method_6296(class_4538 worldIn, class_2338 pos) {
            if (worldIn.method_8320(pos).method_26204() == ModBlocks.OSTRICH_NEST.get()) {
                return (Boolean)worldIn.method_8320(pos).method_11654((class_2769)OstrichNestBlock.EGG) == false;
            }
            if (worldIn.method_8320(pos).method_26204() == class_2246.field_10102) {
                return worldIn.method_22347(pos.method_10084());
            }
            return false;
        }
    }
}

