/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.Lists;
import com.tristankechlo.livingthings.config.entity.SnailConfig;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import com.tristankechlo.livingthings.util.Predicates;
import java.util.ArrayList;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class SnailEntity
extends class_1429
implements ILexiconEntry {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(SnailEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SHELL_COLOR_F = class_2945.method_12791(SnailEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SHELL_COLOR_B = class_2945.method_12791(SnailEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2960[] BODY_TEXTURES = new class_2960[]{SnailEntity.textureLocation("snail_body_1.png")};
    private static final class_2960[] SHELL_TEXTURES_B = new class_2960[]{SnailEntity.textureLocation("snail_shell_b1.png"), SnailEntity.textureLocation("snail_shell_b2.png")};
    private static final class_2960[] SHELL_TEXTURES_F = new class_2960[]{SnailEntity.textureLocation("snail_shell_f1.png"), SnailEntity.textureLocation("snail_shell_f2.png")};

    public SnailEntity(class_1299<? extends class_1429> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    public static boolean checkSnailSpawnRules(class_1299<SnailEntity> animal, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(LivingThingsTags.SNAIL_SPAWNABLE_ON) && SnailEntity.method_39448((class_1920)world, (class_2338)pos);
    }

    private static final class_2960 textureLocation(String name) {
        return class_2960.method_60655((String)"livingthings", (String)("textures/entity/snail/" + name));
    }

    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        SnailEntity snailChild = (SnailEntity)ModEntityTypes.SNAIL.get().method_5883((class_1937)world, class_3730.field_16466);
        if (entity == this) {
            snailChild.setShellColor(PatternType.FOREGROUND, this.getShellColor(PatternType.FOREGROUND));
            snailChild.setShellColor(PatternType.BACKGROUND, this.getShellColor(PatternType.BACKGROUND));
            snailChild.setVariant(this.getVariant());
            return snailChild;
        }
        class_5819 random = world.method_8409();
        if (entity instanceof SnailEntity) {
            SnailEntity parentSnail = (SnailEntity)entity;
            ArrayList colors = Lists.newArrayList((Object[])new Integer[]{this.getShellColor(PatternType.FOREGROUND), this.getShellColor(PatternType.BACKGROUND), parentSnail.getShellColor(PatternType.FOREGROUND), parentSnail.getShellColor(PatternType.BACKGROUND)});
            snailChild.setShellColor(PatternType.FOREGROUND, (Integer)colors.get(random.method_43048(4)));
            snailChild.setShellColor(PatternType.BACKGROUND, (Integer)colors.get(random.method_43048(4)));
            short bodyVariant = random.method_43056() ? this.getBodyVariant() : parentSnail.getBodyVariant();
            short shellVariant = !random.method_43056() ? this.getShellVariant() : parentSnail.getShellVariant();
            snailChild.setVariant(bodyVariant, shellVariant);
        } else {
            SnailVariants preset = SnailVariants.random(random);
            snailChild.setShellColor(PatternType.FOREGROUND, preset.getForegroundColor());
            snailChild.setShellColor(PatternType.BACKGROUND, preset.getBackgroundColor());
            snailChild.setVariant(preset.getVariant());
        }
        return snailChild;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_52450, SnailConfig.temptRange()).method_26868(class_5134.field_23716, SnailConfig.health()).method_26868(class_5134.field_23719, SnailConfig.movementSpeed());
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn) {
        SnailVariants data = SnailVariants.random(worldIn.method_8409());
        this.setVariant(data.getVariant());
        this.setShellColor(PatternType.FOREGROUND, data.getForegroundColor());
        this.setShellColor(PatternType.BACKGROUND, data.getBackgroundColor());
        return super.method_5943(worldIn, difficultyIn, reason, spawnDataIn);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.1, Predicates.SNAIL_FOOD, false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)SnailVariants.NORMAL.getVariant());
        builder.method_56912(SHELL_COLOR_F, (Object)SnailVariants.NORMAL.getForegroundColor());
        builder.method_56912(SHELL_COLOR_B, (Object)SnailVariants.NORMAL.getBackgroundColor());
    }

    public void method_5749(class_11368 compound) {
        super.method_5749(compound);
        this.setVariant(compound.method_71421("SnailVariant", (byte)SnailVariants.NORMAL.getVariant()));
        this.setShellColor(PatternType.FOREGROUND, compound.method_71424("ShellColorF", SnailVariants.NORMAL.getForegroundColor()));
        this.setShellColor(PatternType.BACKGROUND, compound.method_71424("ShellColorB", SnailVariants.NORMAL.getBackgroundColor()));
    }

    public void method_5652(class_11372 compound) {
        super.method_5652(compound);
        compound.method_71465("SnailVariant", this.getVariant());
        compound.method_71465("ShellColorF", this.getShellColor(PatternType.FOREGROUND));
        compound.method_71465("ShellColorB", this.getShellColor(PatternType.BACKGROUND));
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(LivingThingsTags.SNAIL_FOOD);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() instanceof class_1769) {
            class_1767 color = ((class_1769)stack.method_7909()).method_7802();
            if (player.method_18276()) {
                this.setShellColor(PatternType.FOREGROUND, color.method_7787());
            } else {
                this.setShellColor(PatternType.BACKGROUND, color.method_7787());
            }
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            return this.method_73183().method_8608() ? class_1269.field_5812 : class_1269.field_52422;
        }
        return super.method_5992(player, hand);
    }

    public class_2960 getBodyTexture() {
        return BODY_TEXTURES[this.getBodyVariant()];
    }

    private short getBodyVariant() {
        return (short)(this.getVariant() >> 16);
    }

    public class_2960 getShellPatternTexture(PatternType type) {
        return type == PatternType.FOREGROUND ? SHELL_TEXTURES_F[this.getShellVariant()] : SHELL_TEXTURES_B[this.getShellVariant()];
    }

    private short getShellVariant() {
        return (short)this.getVariant();
    }

    public int getVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public void setVariant(short bodyVariant, short shellVariant) {
        this.setVariant(bodyVariant << 16 | shellVariant & 0xFFFF);
    }

    public int getShellColor(PatternType type) {
        if (type == PatternType.FOREGROUND) {
            return (Integer)this.field_6011.method_12789(SHELL_COLOR_F);
        }
        return (Integer)this.field_6011.method_12789(SHELL_COLOR_B);
    }

    public void setShellColor(PatternType type, int color) {
        if (type == PatternType.FOREGROUND) {
            this.field_6011.method_12778(SHELL_COLOR_F, (Object)color);
        } else if (type == PatternType.BACKGROUND) {
            this.field_6011.method_12778(SHELL_COLOR_B, (Object)color);
        }
    }

    public int method_5945() {
        return SnailConfig.maxSpawnedInChunk();
    }

    @Override
    public class_2960 getLexiconEntry() {
        return LexiconEntries.SNAIL;
    }

    public static enum PatternType {
        FOREGROUND,
        BACKGROUND;

    }

    static enum SnailVariants {
        NORMAL(0, 0, 11693105, 8209952),
        GREEN(0, 0, 412975, 2129982),
        PURPLE(0, 0, 6488099, 10238043),
        BLUE(0, 0, 4857561, 6447075),
        RED(0, 0, 10367513, 13586001),
        NORMAL_2(0, 1, 9847813, 7352576);

        private final int variant;
        private final int colorForeground;
        private final int colorBackground;
        private static final SnailVariants[] VALUES;

        private SnailVariants(int bodyVariant, int shellVariant, int colorb, int colorf) {
            this.variant = bodyVariant << 16 | shellVariant & 0xFFFF;
            this.colorBackground = SnailVariants.opaque(colorb);
            this.colorForeground = SnailVariants.opaque(colorf);
        }

        public int getVariant() {
            return this.variant;
        }

        public int getForegroundColor() {
            return this.colorForeground;
        }

        public int getBackgroundColor() {
            return this.colorBackground;
        }

        public static SnailVariants random(class_5819 rand) {
            return VALUES[rand.method_43048(VALUES.length)];
        }

        public static int opaque(int color) {
            return color | 0xFF000000;
        }

        static {
            VALUES = SnailVariants.values();
        }
    }
}

