/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.client.renderer.state.MonkeyRenderState;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MonkeyModel<T extends MonkeyRenderState>
extends AdvancedEntityModel<T> {
    private final ModelPart Body;
    private final ModelPart BodyFront;
    private final ModelPart Head;
    private final ModelPart Tail;
    private final ModelPart Tail2;
    private final ModelPart Tail3;
    private final ModelPart FrontRightLegTop;
    private final ModelPart FrontRightLegBottom;
    private final ModelPart FrontLeftLegTop;
    private final ModelPart FrontLeftLegBottom;
    private final ModelPart BackRightLegTop;
    private final ModelPart BackLeftLegTop;

    public MonkeyModel(ModelPart root) {
        super(root);
        this.Body = root.getChild("Body");
        this.BodyFront = this.Body.getChild("BodyFront");
        this.Head = this.BodyFront.getChild("Head");
        this.Tail = this.Body.getChild("Tail");
        this.Tail2 = this.Tail.getChild("Tail2");
        this.Tail3 = this.Tail2.getChild("Tail3");
        this.FrontRightLegTop = this.BodyFront.getChild("FrontRightLegTop");
        this.FrontRightLegBottom = this.FrontRightLegTop.getChild("FrontRightLegBottom");
        this.FrontLeftLegTop = this.BodyFront.getChild("FrontLeftLegTop");
        this.FrontLeftLegBottom = this.FrontLeftLegTop.getChild("FrontLeftLegBottom");
        this.BackRightLegTop = this.Body.getChild("BackRightLegTop");
        this.BackLeftLegTop = this.Body.getChild("BackLeftLegTop");
    }

    @Override
    public void animate(T state, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((MonkeyRenderState)state).isPartying) {
            this.setPartyAngles();
            this.defaultWalking1(this.BackLeftLegTop, 67.5f, limbSwing, limbSwingAmount);
            this.defaultWalking2(this.BackRightLegTop, 67.5f, limbSwing, limbSwingAmount);
            this.FrontLeftLegTop.zRot = -0.6108f + Mth.cos((float)(ageInTicks * 0.7f)) * 0.2617f;
            this.FrontRightLegTop.zRot = 0.6108f + Mth.cos((float)(ageInTicks * 0.7f + (float)Math.PI)) * 0.2617f;
            this.Head.xRot = 1.3963f + Mth.cos((float)(ageInTicks * 0.7f + (float)Math.PI)) * 0.1745f;
        } else {
            this.setDefaultAngles();
            this.defaultWalking1(this.FrontRightLegTop, 10.0f, limbSwing, limbSwingAmount);
            this.defaultWalking2(this.FrontLeftLegTop, 10.0f, limbSwing, limbSwingAmount);
            this.defaultWalking1(this.BackLeftLegTop, -12.5f, limbSwing, limbSwingAmount);
            this.defaultWalking2(this.BackRightLegTop, -12.5f, limbSwing, limbSwingAmount);
            this.defaultHeadMovement(this.Head, 2.5f, 0.0f, headPitch, netHeadYaw);
            this.Tail.yRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.3f * limbSwingAmount;
            this.Tail2.yRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.7f * limbSwingAmount;
        }
    }

    private void setDefaultAngles() {
        this.Body.setPos(0.0f, 16.8264f, 3.7609f);
        this.setRotationAngle(this.Body, -0.0873f, 0.0f, 0.0f);
        this.Head.setPos(0.0f, -0.2655f, -4.271f);
        this.setRotationAngle(this.Head, 0.0f, 0.0f, 0.0f);
        this.setRotationAngle(this.FrontRightLegTop, 0.1745f, 0.0f, 0.0f);
        this.FrontRightLegBottom.setPos(0.0f, 2.8619f, -0.1854f);
        this.setRotationAngle(this.FrontRightLegBottom, -0.1745f, 0.0f, 0.0f);
        this.setRotationAngle(this.FrontLeftLegTop, 0.1745f, 0.0f, 0.0f);
        this.FrontLeftLegBottom.setPos(0.0f, 2.8865f, -0.1898f);
        this.setRotationAngle(this.FrontLeftLegBottom, -0.1745f, 0.0f, 0.0f);
        this.setRotationAngle(this.BackRightLegTop, -0.2182f, 0.0f, 0.0f);
        this.setRotationAngle(this.BackLeftLegTop, -0.2182f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail, 0.6545f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail2, 0.576f, 0.0f, 0.0f);
        this.Tail3.setPos(0.0f, -0.246f, 3.5488f);
        this.setRotationAngle(this.Tail3, -0.9599f, 0.0f, 0.0f);
    }

    private void setPartyAngles() {
        this.Body.setPos(0.0f, 16.8264f, 0.7609f);
        this.setRotationAngle(this.Body, -1.4835f, 0.0f, 0.0f);
        this.Head.setPos(0.0f, -1.9627f, -5.5457f);
        this.setRotationAngle(this.Head, 1.3963f, 0.0f, 0.0f);
        this.setRotationAngle(this.FrontRightLegTop, 0.1745f, 0.0f, 0.4363f);
        this.FrontRightLegBottom.setPos(-0.425f, 2.2369f, -0.1854f);
        this.setRotationAngle(this.FrontRightLegBottom, 0.0f, 0.0f, -1.1345f);
        this.setRotationAngle(this.FrontLeftLegTop, 0.1745f, 0.0f, -0.4363f);
        this.FrontLeftLegBottom.setPos(0.4f, 2.2365f, -0.1898f);
        this.setRotationAngle(this.FrontLeftLegBottom, 0.0f, 0.0f, 1.1345f);
        this.setRotationAngle(this.BackRightLegTop, 1.1781f, 0.0f, 0.0f);
        this.setRotationAngle(this.BackLeftLegTop, 1.1781f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail, 0.3491f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail2, 0.4451f, 0.0f, 0.0f);
        this.Tail3.setPos(0.0f, 0.0751f, 3.7487f);
        this.setRotationAngle(this.Tail3, 0.6545f, 0.0f, 0.0f);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 14).addBox(-3.0f, -2.9948f, -3.2964f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)16.8264f, (float)3.7609f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition BodyFront = Body.addOrReplaceChild("BodyFront", CubeListBuilder.create().texOffs(0, 23).addBox(-3.0f, -1.8282f, -5.0129f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.174f, (float)-3.1568f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Head = BodyFront.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 5).addBox(-2.5f, -3.9712f, -4.0871f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.2655f, (float)-4.271f));
        PartDefinition MouthTop = Head.addOrReplaceChild("MouthTop", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -0.975f, -2.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.022f, (float)-3.3425f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition MouthBottom = Head.addOrReplaceChild("MouthBottom", CubeListBuilder.create().texOffs(19, 8).addBox(-1.5f, -0.475f, -2.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.2191f, (float)-3.1611f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition EarRight = Head.addOrReplaceChild("EarRight", CubeListBuilder.create().texOffs(28, 21).addBox(-0.5f, -0.95f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-2.1589f, (float)-2.0536f));
        PartDefinition EarLeft = Head.addOrReplaceChild("EarLeft", CubeListBuilder.create().texOffs(28, 21).mirror().addBox(-0.5f, -0.95f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.5f, (float)-2.1589f, (float)-2.0536f));
        PartDefinition FrontRightLegTop = BodyFront.addOrReplaceChild("FrontRightLegTop", CubeListBuilder.create().texOffs(15, 0).mirror().addBox(-1.0f, -0.9462f, -1.1566f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.5f, (float)0.8968f, (float)-3.0129f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition FrontRightLegBottom = FrontRightLegTop.addOrReplaceChild("FrontRightLegBottom", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -0.175f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 30).addBox(-1.0f, 3.825f, -2.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.8619f, (float)-0.1854f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition FrontLeftLegTop = BodyFront.addOrReplaceChild("FrontLeftLegTop", CubeListBuilder.create().texOffs(15, 0).addBox(-1.0f, -0.9462f, -1.1566f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)0.8968f, (float)-3.0129f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition FrontLeftLegBottom = FrontLeftLegTop.addOrReplaceChild("FrontLeftLegBottom", CubeListBuilder.create().texOffs(24, 0).mirror().addBox(-1.0f, -0.2f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 30).mirror().addBox(-1.0f, 3.8f, -2.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.8865f, (float)-0.1898f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition BackRightLegTop = Body.addOrReplaceChild("BackRightLegTop", CubeListBuilder.create().texOffs(15, 0).mirror().addBox(-1.0f, -1.2262f, -0.9925f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.5f, (float)-0.075f, (float)-0.0033f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition BackRightLegBottom = BackRightLegTop.addOrReplaceChild("BackRightLegBottom", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -0.25f, -0.975f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 30).addBox(-1.0f, 3.75f, -1.975f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.6048f, (float)0.0064f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition BackLeftLegTop = Body.addOrReplaceChild("BackLeftLegTop", CubeListBuilder.create().texOffs(15, 0).addBox(-1.0f, -1.3012f, -0.9925f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition BackLeftLegBottom = BackLeftLegTop.addOrReplaceChild("BackLeftLegBottom", CubeListBuilder.create().texOffs(24, 0).mirror().addBox(-1.0f, -0.325f, -0.875f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 30).mirror().addBox(-1.0f, 3.675f, -1.875f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.6273f, (float)-0.0651f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(18, 20).addBox(-1.0f, -0.95f, 0.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.7519f, (float)0.3378f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail.addOrReplaceChild("Tail2", CubeListBuilder.create().texOffs(22, 14).addBox(-0.5f, -0.575f, 0.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.0568f, (float)4.3282f, (float)0.576f, (float)0.0f, (float)0.0f));
        PartDefinition Tail3 = Tail2.addOrReplaceChild("Tail3", CubeListBuilder.create().texOffs(18, 13).addBox(-0.5f, -0.575f, 0.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.246f, (float)3.5488f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }
}

