/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.client.renderer.state.OwlRenderState;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class OwlModel<T extends OwlRenderState>
extends AdvancedEntityModel<T> {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart Tail;
    private final ModelPart LeftWing;
    private final ModelPart RightWing;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;

    public OwlModel(ModelPart root) {
        super(root);
        this.Body = root.getChild("Body");
        this.Head = this.Body.getChild("Head");
        this.Tail = this.Body.getChild("Tail");
        this.LeftWing = this.Body.getChild("LeftWing");
        this.RightWing = this.Body.getChild("RightWing");
        this.LeftLeg = this.Body.getChild("LeftLeg");
        this.RightLeg = this.Body.getChild("RightLeg");
    }

    @Override
    public void animate(T state, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setRotationAngles((OwlRenderState)state, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void setRotationAngles(OwlRenderState state, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.xRot = -0.174532f + headPitch * ((float)Math.PI / 180);
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.zRot = 0.0f;
        this.Head.x = 0.0f;
        this.Body.x = 0.0f;
        this.Tail.x = 0.0f;
        this.RightWing.x = -3.5f;
        this.LeftWing.x = 3.5f;
        switch (state.pose) {
            case SITTING: {
                break;
            }
            case STANDING: {
                this.LeftLeg.xRot += Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
                this.RightLeg.xRot += Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
                break;
            }
            default: {
                this.Tail.xRot = -0.959931f + Mth.cos((float)(limbSwing * 0.6662f)) * 0.3f * limbSwingAmount;
                this.LeftWing.zRot = -0.1309f - state.flapAngle;
                this.RightWing.zRot = 0.1309f + state.flapAngle;
            }
        }
    }

    public void setLivingAnimations(OwlRenderState state) {
        this.Body.xRot = 0.174532f;
        this.LeftWing.xRot = 0.0f;
        this.LeftWing.yRot = 0.0f;
        this.LeftWing.zRot = -0.130899f;
        this.RightWing.xRot = 0.0f;
        this.RightWing.yRot = 0.0f;
        this.RightWing.zRot = 0.130899f;
        this.LeftLeg.xRot = -0.261799f;
        this.LeftLeg.y = -1.9107f;
        this.LeftLeg.zRot = 0.0f;
        this.RightLeg.xRot = -0.261799f;
        this.RightLeg.y = -1.9107f;
        this.RightLeg.zRot = 0.0f;
        switch (state.pose) {
            case SITTING: {
                this.Body.xRot = 0.0f;
                this.LeftLeg.xRot = 0.0f;
                this.RightLeg.xRot = 0.0f;
                break;
            }
            case FALL_FLYING: {
                if (!state.isMoving) break;
                this.LeftLeg.xRot += 0.6981317f;
                this.RightLeg.xRot += 0.6981317f;
                break;
            }
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 17).addBox(-3.5f, -9.025f, -3.5f, 7.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)21.5f, (float)1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition LeftWing = Body.addOrReplaceChild("LeftWing", CubeListBuilder.create().texOffs(0, 1).addBox(0.0f, 0.0f, -3.0f, 1.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)-8.5792f, (float)-0.4056f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition RightWing = Body.addOrReplaceChild("RightWing", CubeListBuilder.create().texOffs(15, 1).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)-8.5792f, (float)-0.4056f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition LeftLeg = Body.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(31, 1).addBox(-1.0f, 0.1224f, -0.5671f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-1.9107f, (float)-1.5699f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFoot = LeftLeg.addOrReplaceChild("LeftFoot", CubeListBuilder.create().texOffs(40, 3).addBox(-1.0667f, -0.0681f, -1.058f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0667f, (float)3.0978f, (float)0.5107f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightToeLeftFoot = LeftFoot.addOrReplaceChild("RightToeLeftFoot", CubeListBuilder.create().texOffs(49, 4).addBox(-0.5f, -0.475f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5667f, (float)0.4082f, (float)-1.0494f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition LeftToeLeftFoot = LeftFoot.addOrReplaceChild("LeftToeLeftFoot", CubeListBuilder.create().texOffs(54, 4).addBox(-0.5f, -0.5f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.4333f, (float)0.4332f, (float)-1.0494f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition RightLeg = Body.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(31, 7).addBox(-1.0f, 0.1224f, -0.5671f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-1.9107f, (float)-1.5699f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition RightFoot = RightLeg.addOrReplaceChild("RightFoot", CubeListBuilder.create().texOffs(40, 9).addBox(-1.0667f, -0.0681f, -1.058f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0667f, (float)3.0978f, (float)0.5107f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightToeRightFoot = RightFoot.addOrReplaceChild("RightToeRightFoot", CubeListBuilder.create().texOffs(49, 10).addBox(-0.5f, -0.475f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5667f, (float)0.4082f, (float)-1.0494f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition LeftToeRightFoot = RightFoot.addOrReplaceChild("LeftToeRightFoot", CubeListBuilder.create().texOffs(54, 10).addBox(-0.5f, -0.5f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.4333f, (float)0.4332f, (float)-1.0494f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(31, 13).addBox(-1.0f, -0.5186f, -0.2595f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.7652f, (float)1.3264f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(27, 20).addBox(-3.5f, -6.0f, -3.25f, 7.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.5045f, (float)-0.1394f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition Beak = Head.addOrReplaceChild("Beak", CubeListBuilder.create().texOffs(42, 14).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.25f, (float)-2.7f, (float)0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }
}

