/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;

public class RaccoonModel<T extends LivingEntityRenderState>
extends AdvancedEntityModel<T> {
    private final ModelPart Head;
    private final ModelPart Tail;
    private final ModelPart LegFrontRight;
    private final ModelPart LegFrontLeft;
    private final ModelPart LegBackRight;
    private final ModelPart LegBackLeft;

    public RaccoonModel(ModelPart root) {
        super(root);
        ModelPart body = root.getChild("Body");
        this.Head = body.getChild("Head");
        this.Tail = body.getChild("Tail");
        this.LegFrontRight = body.getChild("LegFrontRight");
        this.LegFrontLeft = body.getChild("LegFrontLeft");
        this.LegBackRight = body.getChild("LegBackRight");
        this.LegBackLeft = body.getChild("LegBackLeft");
    }

    @Override
    protected void animate(T state, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.Head.yRot = netHeadYaw / 3.75f * ((float)Math.PI / 180);
        this.walk(this.LegFrontRight, this.LegFrontLeft, this.LegBackRight, this.LegBackLeft, limbSwing, limbSwingAmount);
        this.Tail.yRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.75f * limbSwingAmount;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 1).addBox(-3.0f, -11.0f, -5.5f, 6.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition LegFrontLeft = Body.addOrReplaceChild("LegFrontLeft", CubeListBuilder.create().texOffs(0, 25).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.75f, (float)-5.0f, (float)-3.5f));
        PartDefinition LegBackLeft = Body.addOrReplaceChild("LegBackLeft", CubeListBuilder.create().texOffs(9, 25).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.75f, (float)-5.0f, (float)3.5f));
        PartDefinition LegFrontRight = Body.addOrReplaceChild("LegFrontRight", CubeListBuilder.create().texOffs(18, 25).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.75f, (float)-5.0f, (float)-3.5f));
        PartDefinition LegBackRight = Body.addOrReplaceChild("LegBackRight", CubeListBuilder.create().texOffs(27, 25).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.75f, (float)-5.0f, (float)3.5f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(36, 20).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.95f, (float)4.65f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(36, 7).addBox(-4.0f, -3.0f, -5.0f, 8.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-9.0f, (float)-5.5f));
        PartDefinition LeftEar = Head.addOrReplaceChild("LeftEar", CubeListBuilder.create().texOffs(0, 20).addBox(-1.0f, -1.75f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-3.0f, (float)-2.0f));
        PartDefinition RightEar = Head.addOrReplaceChild("RightEar", CubeListBuilder.create().texOffs(7, 20).addBox(-1.0f, -1.75f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-3.0f, (float)-1.75f));
        PartDefinition Mouth = Head.addOrReplaceChild("Mouth", CubeListBuilder.create().texOffs(25, 4).addBox(-2.0f, -1.5f, -3.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.25f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }
}

