/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.renderer;

import com.tristankechlo.livingthings.client.ModelLayer;
import com.tristankechlo.livingthings.client.model.entity.SnailModel;
import com.tristankechlo.livingthings.client.renderer.AgeableMobRenderer;
import com.tristankechlo.livingthings.client.renderer.layer.SnailShellPatternLayer;
import com.tristankechlo.livingthings.client.renderer.state.SnailRenderState;
import com.tristankechlo.livingthings.entity.SnailEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class SnailRenderer
extends AgeableMobRenderer<SnailEntity, SnailRenderState, EntityModel<SnailRenderState>> {
    public static final MeshTransformer NORMAL_TRANSFORMER = MeshTransformer.scaling((float)0.8f);
    public static final MeshTransformer BABY_TRANSFORMER = MeshTransformer.scaling((float)0.45f);

    public SnailRenderer(EntityRendererProvider.Context context) {
        super(context, SnailModel::new, ModelLayer.SNAIL, ModelLayer.SNAIL_BABY, 0.35f);
        this.addLayer(new SnailShellPatternLayer(this, context.getModelSet(), SnailEntity.PatternType.BACKGROUND));
        this.addLayer(new SnailShellPatternLayer(this, context.getModelSet(), SnailEntity.PatternType.FOREGROUND));
    }

    public SnailRenderState createRenderState() {
        return new SnailRenderState();
    }

    public void extractRenderState(SnailEntity snail, SnailRenderState state, float $$2) {
        super.extractRenderState((LivingEntity)snail, (LivingEntityRenderState)state, $$2);
        state.fromEntity(snail);
    }

    public ResourceLocation getTextureLocation(SnailRenderState snail) {
        return snail.bodyTexture;
    }
}

