/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.PenguinConfig;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import com.tristankechlo.livingthings.util.Predicates;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class PenguinEntity
extends Animal
implements ILexiconEntry {
    public PenguinEntity(EntityType<PenguinEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public static boolean checkPenguinSpawnRules(EntityType<PenguinEntity> animal, ServerLevelAccessor world, EntitySpawnReason reason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(LivingThingsTags.PENGUIN_SPAWNABLE_ON) && PenguinEntity.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public AgeableMob getBreedOffspring(ServerLevel worldIn, AgeableMob parent) {
        return (AgeableMob)ModEntityTypes.PENGUIN.get().create((Level)worldIn, EntitySpawnReason.BREEDING);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.TEMPT_RANGE, PenguinConfig.temptRange()).add(Attributes.MAX_HEALTH, PenguinConfig.health()).add(Attributes.MOVEMENT_SPEED, PenguinConfig.movementSpeed());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 8.0f, 1.0, 1.2));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Predicates.PENGUIN_FOOD, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, PenguinEntity.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(LivingThingsTags.PENGUIN_FOOD);
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    public int getAmbientSoundInterval() {
        return PenguinConfig.talkInterval();
    }

    public int getMaxSpawnClusterSize() {
        return PenguinConfig.maxSpawnedInChunk();
    }

    protected SoundEvent getAmbientSound() {
        return ModSounds.PENGUIN_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.PENGUIN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.PENGUIN_DEATH.get();
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.PENGUIN;
    }
}

