/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.platform;

import com.google.auto.service.AutoService;
import com.tristankechlo.livingthings.platform.RegistrationProvider;
import com.tristankechlo.livingthings.platform.RegistryObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.registries.DeferredRegister;

@AutoService(value={RegistrationProvider.Factory.class})
public final class ForgeRegistrationFactory
implements RegistrationProvider.Factory {
    @Override
    public <T> RegistrationProvider<T> create(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        Optional containerOpt = ModList.get().getModContainerById(modId);
        if (containerOpt.isEmpty()) {
            throw new NullPointerException("Cannot find mod container for id " + modId);
        }
        ModContainer cont = (ModContainer)containerOpt.get();
        if (cont instanceof FMLModContainer) {
            FMLModContainer fmlModContainer = (FMLModContainer)cont;
            DeferredRegister registry = DeferredRegister.create(resourceKey, (String)modId);
            registry.register(fmlModContainer.getModBusGroup());
            return new Provider(modId, registry);
        }
        throw new ClassCastException("The container of the mod " + modId + " is not a FML one!");
    }

    private static class Provider<T>
    implements RegistrationProvider<T> {
        private final String modId;
        private final DeferredRegister<T> registry;
        private final Set<RegistryObject<T>> entries = new HashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(String modId, DeferredRegister<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        @Override
        public String getModId() {
            return this.modId;
        }

        @Override
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            net.minecraftforge.registries.RegistryObject obj = this.registry.register(name, supplier);
            ForgeRegistryObject ro = new ForgeRegistryObject(obj);
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Set<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }

        public static class ForgeRegistryObject<I>
        implements RegistryObject<I> {
            private final net.minecraftforge.registries.RegistryObject<I> value;

            public ForgeRegistryObject(net.minecraftforge.registries.RegistryObject<I> value) {
                this.value = value;
            }

            @Override
            public ResourceKey<I> getResourceKey() {
                return this.value.getKey();
            }

            @Override
            public ResourceLocation getId() {
                return this.value.getId();
            }

            @Override
            public I get() {
                return (I)this.value.get();
            }

            @Override
            public Holder<I> asHolder() {
                Optional holder = this.value.getHolder();
                if (holder.isEmpty()) {
                    throw new IllegalStateException("Holder is empty for " + String.valueOf(this.getId()));
                }
                return (Holder)holder.get();
            }
        }
    }
}

