/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.client.renderer.state.NetherKnightRenderState;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class NetherKnightModel<T extends NetherKnightRenderState>
extends AdvancedEntityModel<T>
implements ArmedModel {
    private final ModelPart Head;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;

    public NetherKnightModel(ModelPart root) {
        super(root);
        ModelPart body = root.getChild("Body");
        this.Head = body.getChild("Head");
        this.RightArm = body.getChild("RightArm");
        this.LeftArm = body.getChild("LeftArm");
        this.RightLeg = body.getChild("RightLeg");
        this.LeftLeg = body.getChild("LeftLeg");
    }

    @Override
    public void animate(T state, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.defaultHeadMovement(this.Head, 0.0f, 0.0f, headPitch, netHeadYaw);
        this.LeftArm.xRot = 0.0f;
        this.LeftArm.zRot = 0.0f;
        this.RightArm.xRot = 0.0f;
        this.RightArm.zRot = 0.0f;
        this.walking1(this.LeftLeg, limbSwing, limbSwingAmount);
        this.walking2(this.RightLeg, limbSwing, limbSwingAmount);
        this.walking2(this.LeftArm, limbSwing, limbSwingAmount * 0.75f);
        this.walking1(this.RightArm, limbSwing, limbSwingAmount * 0.75f);
        this.setupAttackAnimation(state, ageInTicks);
    }

    public void translateToHand(EntityRenderState renderState, HumanoidArm arm, PoseStack poseStack) {
        this.getArm(arm).translateAndRotate(poseStack);
    }

    private ModelPart getArm(HumanoidArm handSide) {
        return handSide == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    private void setupAttackAnimation(T state, float ageInTicks) {
        if (((NetherKnightRenderState)state).attackTime > 0.0f) {
            float f = Mth.sin((float)(((NetherKnightRenderState)state).attackTime * (float)Math.PI));
            float f1 = Mth.sin((float)((1.0f - (1.0f - ((NetherKnightRenderState)state).attackTime) * (1.0f - ((NetherKnightRenderState)state).attackTime)) * (float)Math.PI));
            this.LeftArm.zRot = 0.0f;
            this.RightArm.zRot = 0.0f;
            this.LeftArm.yRot = 0.15707964f;
            this.RightArm.yRot = -0.15707964f;
            if (((NetherKnightRenderState)state).mainArm == HumanoidArm.RIGHT) {
                this.RightArm.xRot = -Mth.cos((float)(ageInTicks * 0.1f)) * 0.5f;
                this.RightArm.xRot -= f * 1.2f + f1 * 0.4f;
            } else {
                this.LeftArm.xRot = -Mth.cos((float)(ageInTicks * 0.1f)) * 0.5f;
                this.LeftArm.xRot -= f * 1.2f + f1 * 0.4f;
            }
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 53).addBox(-6.0f, -3.8f, -2.0f, 12.0f, 7.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(0, 41).addBox(-4.5f, 3.0f, -2.0f, 9.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -9.0f, -4.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(20, 39).addBox(-3.0f, -5.75f, -3.975f, 6.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -3.5f, -5.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition Horn1 = Head.addOrReplaceChild("Horn1", CubeListBuilder.create().texOffs(0, 19).addBox(-7.0f, -14.0f, 0.0f, 14.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition Horn2 = Head.addOrReplaceChild("Horn2", CubeListBuilder.create().texOffs(0, 19).mirror().addBox(-7.0f, -14.0f, 0.0f, 14.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition RightArm = Body.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(48, 46).mirror().addBox(-2.15f, -1.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.25f)).mirror(false).texOffs(48, 11).addBox(-2.15f, -1.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.5f)).texOffs(48, 37).mirror().addBox(-2.15f, 8.9f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-8.0f, (float)-2.0f, (float)0.0f));
        PartDefinition RightShoulder = RightArm.addOrReplaceChild("RightShoulder", CubeListBuilder.create().texOffs(48, 29).mirror().addBox(-1.9f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.6f)).mirror(false), PartPose.offsetAndRotation((float)-0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition LeftArm = Body.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(48, 46).addBox(-1.85f, -1.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.25f)).texOffs(48, 11).addBox(-1.85f, -1.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.5f)).texOffs(48, 37).addBox(-1.85f, 8.9f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)-2.0f, (float)0.0f));
        PartDefinition LeftShoulder = LeftArm.addOrReplaceChild("LeftShoulder", CubeListBuilder.create().texOffs(48, 29).addBox(-1.6f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.offsetAndRotation((float)-0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition RightLeg = Body.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(32, 47).addBox(-2.3f, -2.1f, -2.0f, 4.0f, 13.0f, 4.0f, new CubeDeformation(-0.1f)).texOffs(32, 30).addBox(-2.3f, -2.1f, -2.0f, 4.0f, 13.0f, 4.0f, new CubeDeformation(-0.2f)).texOffs(0, 33).addBox(-2.3f, 8.9f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)-1.9f, (float)11.0f, (float)0.0f));
        PartDefinition LeftLeg = Body.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(32, 47).mirror().addBox(-1.7f, -3.1f, -2.0f, 4.0f, 13.0f, 4.0f, new CubeDeformation(-0.1f)).mirror(false).texOffs(32, 30).mirror().addBox(-1.7f, -3.1f, -2.0f, 4.0f, 13.0f, 4.0f, new CubeDeformation(-0.2f)).mirror(false).texOffs(0, 33).mirror().addBox(-1.7f, 7.9f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.1f)).mirror(false), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

