/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tristankechlo.livingthings.LivingThings;
import com.tristankechlo.livingthings.client.ModelLayer;
import com.tristankechlo.livingthings.client.model.entity.OwlModel;
import com.tristankechlo.livingthings.client.renderer.AgeableMobRenderer;
import com.tristankechlo.livingthings.client.renderer.state.OwlRenderState;
import com.tristankechlo.livingthings.entity.OwlEntity;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class OwlRenderer
extends AgeableMobRenderer<OwlEntity, OwlRenderState, OwlModel<OwlRenderState>> {
    protected static final ResourceLocation TEXTURE_BROWN = LivingThings.getEntityTexture("owl/owl_brown.png");
    protected static final ResourceLocation TEXTURE_WHITE = LivingThings.getEntityTexture("owl/owl_white.png");
    protected static final ResourceLocation TEXTURE_BLACK = LivingThings.getEntityTexture("owl/owl_black.png");
    public static final MeshTransformer NORMAL_TRANSFORMER = MeshTransformer.scaling((float)0.94f);
    public static final MeshTransformer BABY_TRANSFORMER = MeshTransformer.scaling((float)0.5f);

    public OwlRenderer(EntityRendererProvider.Context context) {
        super(context, OwlModel::new, ModelLayer.OWL, ModelLayer.OWL_BABY, 0.29f);
    }

    public OwlRenderState createRenderState() {
        return new OwlRenderState();
    }

    public void extractRenderState(OwlEntity entity, OwlRenderState state, float $$2) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, $$2);
        state.fromEntity(entity);
        state.flapAngle(entity, $$2);
    }

    public ResourceLocation getTextureLocation(OwlRenderState state) {
        byte variant = state.variant;
        if (variant == 1) {
            return TEXTURE_WHITE;
        }
        if (variant == 2) {
            return TEXTURE_BLACK;
        }
        return TEXTURE_BROWN;
    }

    protected void setupRotations(OwlRenderState state, PoseStack poseStack, float f1, float f2) {
        super.setupRotations((LivingEntityRenderState)state, poseStack, f1, f2);
        ((OwlModel)this.model).setLivingAnimations(state);
    }
}

