/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tristankechlo.livingthings.LivingThings;
import com.tristankechlo.livingthings.util.ProjectLinks;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class LivingThingsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"livingthings").then(Commands.literal((String)"github").executes(context -> LivingThingsCommand.display((CommandContext<CommandSourceStack>)context, ProjectLinks.GITHUB)))).then(Commands.literal((String)"issue").executes(context -> LivingThingsCommand.display((CommandContext<CommandSourceStack>)context, ProjectLinks.GITHUB_ISSUES)))).then(Commands.literal((String)"wiki").executes(context -> LivingThingsCommand.display((CommandContext<CommandSourceStack>)context, ProjectLinks.GITHUB_WIKI)))).then(Commands.literal((String)"discord").executes(context -> LivingThingsCommand.display((CommandContext<CommandSourceStack>)context, ProjectLinks.DISCORD)))).then(Commands.literal((String)"curseforge").executes(context -> LivingThingsCommand.display((CommandContext<CommandSourceStack>)context, ProjectLinks.CURSEFORGE)))).then(Commands.literal((String)"modrinth").executes(context -> LivingThingsCommand.display((CommandContext<CommandSourceStack>)context, ProjectLinks.MODRINTH)));
        dispatcher.register(command);
        LivingThings.LOGGER.info("Command '/{}' registered", (Object)"livingthings");
    }

    private static int display(CommandContext<CommandSourceStack> context, ProjectLinks type) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MutableComponent link = LivingThingsCommand.clickableLink(type);
        MutableComponent message = Component.literal((String)type.getMessage()).withStyle(ChatFormatting.WHITE).append((Component)link);
        LivingThingsCommand.sendMessage(source, (Component)message, false);
        return 1;
    }

    private static MutableComponent start() {
        return Component.literal((String)"[Living Things] ").withStyle(ChatFormatting.GOLD);
    }

    private static void sendMessage(CommandSourceStack source, Component message, boolean broadcastToOps) {
        MutableComponent start = LivingThingsCommand.start().append(message);
        source.sendSuccess(() -> start, broadcastToOps);
    }

    private static MutableComponent clickableLink(ProjectLinks type) {
        MutableComponent mutableComponent = Component.literal((String)type.getUrl());
        mutableComponent.withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE});
        mutableComponent.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(type.getUri())));
        return mutableComponent;
    }
}

