/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.tristankechlo.livingthings.LivingThings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;

public final class SpawnData {
    private final List<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
    private final int weight;
    private final int minCount;
    private final int maxCount;

    public SpawnData(int weight, int minCount, int maxCount, ResourceKey<Biome>[] biomes) {
        this(weight, minCount, maxCount, Arrays.stream(biomes).map(ResourceKey::location).toList());
    }

    public SpawnData(int weight, int minCount, int maxCount, List<ResourceLocation> biomes) {
        this.weight = weight;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.biomes.addAll(biomes);
    }

    public Weighted<MobSpawnSettings.SpawnerData> asSpawnerData(EntityType<?> entityType) {
        return new Weighted((Object)new MobSpawnSettings.SpawnerData(entityType, this.minCount, this.maxCount), this.weight);
    }

    public List<ResourceLocation> getBiomes() {
        return this.biomes;
    }

    public static JsonElement serialize(SpawnData spawnData) {
        JsonObject json = new JsonObject();
        json.addProperty("weight", (Number)spawnData.weight);
        json.addProperty("minGroupSize", (Number)spawnData.minCount);
        json.addProperty("maxGroupSize", (Number)spawnData.maxCount);
        JsonArray biomes = new JsonArray();
        spawnData.biomes.forEach(biome -> {
            JsonPrimitive primitive = new JsonPrimitive(biome.toString());
            biomes.add((JsonElement)primitive);
        });
        json.add("biomes", (JsonElement)biomes);
        return json;
    }

    public static SpawnData deserialize(JsonElement jsonElement) {
        JsonObject json = GsonHelper.convertToJsonObject((JsonElement)jsonElement, (String)"spawnData");
        int weight = GsonHelper.getAsInt((JsonObject)json, (String)"weight");
        int minCount = GsonHelper.getAsInt((JsonObject)json, (String)"minGroupSize");
        int maxCount = GsonHelper.getAsInt((JsonObject)json, (String)"maxGroupSize");
        ArrayList<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
        JsonArray biomesArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"biomes");
        for (JsonElement biomeElement : biomesArray) {
            String biomeString = GsonHelper.convertToString((JsonElement)biomeElement, (String)"biome");
            ResourceLocation biomeLoc = ResourceLocation.tryParse((String)biomeString);
            if (biomeLoc == null) {
                LivingThings.LOGGER.error("Ignoring invalid biome: {}", (Object)biomeString);
                continue;
            }
            biomes.add(biomeLoc);
        }
        return new SpawnData(weight, minCount, maxCount, biomes);
    }
}

