/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.OwlConfig;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import com.tristankechlo.livingthings.util.Predicates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class OwlEntity
extends TamableAnimal
implements FlyingAnimal,
IMobVariants,
ILexiconEntry {
    private static final EntityDataAccessor<Byte> OWL_VARIANT = SynchedEntityData.defineId(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;

    public OwlEntity(EntityType<? extends OwlEntity> type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        OwlEntity child = (OwlEntity)ModEntityTypes.OWL.get().create((Level)world, EntitySpawnReason.BREEDING);
        EntityReference uuid = this.getOwnerReference();
        if (uuid == null && entity instanceof TamableAnimal) {
            uuid = ((TamableAnimal)entity).getOwnerReference();
        }
        if (uuid != null) {
            child.setOwnerReference(uuid);
            child.setTame(true, false);
        }
        child.setVariant(this.getVariantFromParents((AgeableMob)this, entity));
        return child;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.TEMPT_RANGE, OwlConfig.temptRange()).add(Attributes.MAX_HEALTH, OwlConfig.health()).add(Attributes.MOVEMENT_SPEED, OwlConfig.movementSpeed()).add(Attributes.FLYING_SPEED, OwlConfig.flyingSpeed());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, EntitySpawnReason reason, SpawnGroupData spawnDataIn) {
        int colorBrownWeight = (Integer)OwlConfig.get().colorBrownWeight.get();
        int colorWhiteWeight = (Integer)OwlConfig.get().colorWhiteWeight.get();
        int colorBlackWeight = (Integer)OwlConfig.get().colorBlackWeight.get();
        byte variant = this.getRandomVariant(this.random, new byte[]{0, 1, 2}, new int[]{colorBrownWeight, colorWhiteWeight, colorBlackWeight});
        this.setVariant(variant);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Predicates.OWL_FOOD, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 5.0f, 1.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(OWL_VARIANT, (Object)0);
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(compound.getByteOr("OwlVariant", (byte)0));
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("OwlVariant", this.getVariant());
    }

    public void aiStep() {
        super.aiStep();
        this.calculateFlapping();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!this.isTame() && this.isFood(stack)) {
            this.usePlayerItem(player, hand, stack);
            if (this.random.nextInt(5) == 0) {
                this.tame(player);
                this.setOrderedToSit(true);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return this.level().isClientSide() ? InteractionResult.SUCCESS : InteractionResult.SUCCESS_SERVER;
        }
        if (this.isTame() && !this.isFlying()) {
            InteractionResult result = super.mobInteract(player, hand);
            if ((!result.consumesAction() || this.isBaby()) && this.isOwnedBy((LivingEntity)player)) {
                this.setOrderedToSit(!this.isOrderedToSit());
                return InteractionResult.SUCCESS;
            }
            return result;
        }
        return InteractionResult.PASS;
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(!this.onGround() && !this.isPassenger() ? 4 : -1) * 0.3);
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3 vector3d = this.getDeltaMovement();
        if (!this.onGround() && vector3d.y < 0.0) {
            this.setDeltaMovement(vector3d.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    public static boolean checkOwlSpawnRules(EntityType<OwlEntity> animal, LevelAccessor world, EntitySpawnReason reason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(LivingThingsTags.OWL_SPAWNABLE_ON) && OwlEntity.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, worldIn);
        navigation.setCanOpenDoors(false);
        navigation.setCanFloat(true);
        navigation.setCanOpenDoors(true);
        return navigation;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(LivingThingsTags.OWL_FOOD);
    }

    public int getMaxSpawnClusterSize() {
        return OwlConfig.maxSpawnedInChunk();
    }

    public boolean causeFallDamage(double p_149683_, float p_149684_, DamageSource p_149685_) {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return ModSounds.OWL_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return ModSounds.OWL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.OWL_DEATH.get();
    }

    protected void onFlap() {
        this.playSound(ModSounds.OWL_FLY.get(), 0.15f, 1.0f);
    }

    protected void doPush(Entity entityIn) {
        if (!(entityIn instanceof Player)) {
            super.doPush(entityIn);
        }
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        if (this.isInvulnerableTo(level, source)) {
            return false;
        }
        this.setOrderedToSit(false);
        return super.hurtServer(level, source, amount);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    @Override
    public byte getVariant() {
        return (Byte)this.entityData.get(OWL_VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.entityData.set(OWL_VARIANT, (Object)variant);
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.OWL;
    }
}

