/*
 * Decompiled with CFR 0.152.
 */
package com.github.slaxlax.maxrepel.blockentities;

import com.github.slaxlax.maxrepel.block.CreativeSprayerBlock;
import com.github.slaxlax.maxrepel.registry.BlockEntitiesRegistry;
import com.github.slaxlax.maxrepel.registry.POIRegistry;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u000eJ\u000f\u0010\u0014\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/github/slaxlax/maxrepel/blockentities/CreativeSprayerBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdatePacket", "()Lnet/minecraft/network/protocol/Packet;", "", "clientTick", "()V", "", "isActive", "handleActiveStateChange", "(Z)V", "registerPoi", "unregisterPoi", "MaxRepel-neoforge"})
@SourceDebugExtension(value={"SMAP\nCreativeSprayerBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreativeSprayerBlockEntity.kt\ncom/github/slaxlax/maxrepel/blockentities/CreativeSprayerBlockEntity\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,86:1\n13805#2,2:87\n*S KotlinDebug\n*F\n+ 1 CreativeSprayerBlockEntity.kt\ncom/github/slaxlax/maxrepel/blockentities/CreativeSprayerBlockEntity\n*L\n50#1:87,2\n*E\n"})
public final class CreativeSprayerBlockEntity
extends BlockEntity {
    public CreativeSprayerBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super((BlockEntityType)BlockEntitiesRegistry.INSTANCE.getCREATIVE_SPRAYER().get(), pos, state);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::getUpdateTag);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    public final void clientTick() {
        Pair[] basePositions;
        if (!((Boolean)this.getBlockState().getValue((Property)CreativeSprayerBlock.Companion.getACTIVE())).booleanValue()) {
            return;
        }
        double x = (double)this.getBlockPos().getX() + 0.5;
        double y = (double)this.getBlockPos().getY() + 0.4;
        double z = (double)this.getBlockPos().getZ() + 0.5;
        double radius = 0.7;
        double speed = 0.04;
        Level level = this.level;
        float rotationDegrees = (float)(level != null ? level.getGameTime() : 0L) * 4.0f % 360.0f;
        double rotationRad = Math.toRadians(rotationDegrees);
        float r = 0.36078432f;
        float g = 0.5803922f;
        float b = 0.26666668f;
        DustParticleOptions colorParticle = new DustParticleOptions(new Vector3f(r, g, b), 1.0f);
        Pair[] pairArray = new Pair[]{new Pair((Object)radius, (Object)0.0), new Pair((Object)(-radius), (Object)0.0), new Pair((Object)0.0, (Object)radius), new Pair((Object)0.0, (Object)(-radius))};
        Pair[] $this$forEach$iv = basePositions = pairArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Pair element$iv;
            Pair pair = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            double dx = ((Number)pair.component1()).doubleValue();
            double dz = ((Number)pair.component2()).doubleValue();
            double rotatedX = Math.cos(rotationRad) * dx + Math.sin(rotationRad) * dz;
            double rotatedZ = -Math.sin(rotationRad) * dx + Math.cos(rotationRad) * dz;
            Level level2 = this.level;
            if (level2 == null) continue;
            level2.addParticle((ParticleOptions)colorParticle, x + rotatedX, y, z + rotatedZ, rotatedX * speed, 0.0, rotatedZ * speed);
        }
    }

    public final void handleActiveStateChange(boolean isActive) {
        if (!(this.level instanceof ServerLevel)) {
            return;
        }
        if (isActive) {
            this.registerPoi();
        } else {
            this.unregisterPoi();
        }
    }

    private final void registerPoi() {
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        serverLevel2.getPoiManager().add(this.getBlockPos(), (Holder)POIRegistry.INSTANCE.getSPRAYER_POI());
    }

    private final void unregisterPoi() {
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        serverLevel2.getPoiManager().remove(this.getBlockPos());
    }
}

