/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import world.landfall.landfallessentials.client.model.ModModelRegistry;
import world.landfall.landfallessentials.item.custom.ConduitItem;
import world.landfall.landfallessentials.item.custom.ConduitType;

public class ConduitItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private ModelPart conduitModel;

    public ConduitItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack itemStack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Item item = itemStack.getItem();
        if (!(item instanceof ConduitItem)) {
            return;
        }
        ConduitItem conduitItem = (ConduitItem)item;
        if (this.conduitModel == null) {
            this.conduitModel = Minecraft.getInstance().getEntityModels().bakeLayer(ModModelRegistry.CONDUIT);
        }
        ConduitType type = conduitItem.getConduitType();
        Color stoneColor = type.getStoneColor();
        Color glintColor = type.getGlintColor();
        poseStack.pushPose();
        switch (displayContext) {
            case GUI: {
                poseStack.scale(0.625f, 0.625f, 0.625f);
                poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(225.0f));
                break;
            }
            case GROUND: {
                poseStack.scale(0.25f, 0.25f, 0.25f);
                poseStack.translate(0.0f, 3.0f, 0.0f);
                break;
            }
            case FIXED: {
                poseStack.scale(0.5f, 0.5f, 0.5f);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                poseStack.scale(0.375f, 0.375f, 0.375f);
                poseStack.translate(0.0, 2.5, 0.0);
                poseStack.mulPose(Axis.XP.rotationDegrees(75.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                poseStack.scale(0.4f, 0.4f, 0.4f);
                poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                poseStack.scale(0.4f, 0.4f, 0.4f);
                poseStack.mulPose(Axis.YP.rotationDegrees(225.0f));
                break;
            }
            case HEAD: 
            case NONE: {
                poseStack.scale(0.5f, 0.5f, 0.5f);
                break;
            }
            default: {
                poseStack.scale(0.5f, 0.5f, 0.5f);
            }
        }
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.translucent());
        float alpha = 0.7f;
        int colorWithAlpha = (int)(alpha * 255.0f) << 24 | stoneColor.getRed() << 16 | stoneColor.getGreen() << 8 | stoneColor.getBlue();
        this.conduitModel.render(poseStack, vertexConsumer, packedLight, packedOverlay, colorWithAlpha);
        if (displayContext != ItemDisplayContext.GUI) {
            VertexConsumer glintConsumer = buffer.getBuffer(RenderType.glint());
            int glintColorWithAlpha = 0x7F000000 | glintColor.getRed() << 16 | glintColor.getGreen() << 8 | glintColor.getBlue();
            this.conduitModel.render(poseStack, glintConsumer, packedLight, packedOverlay, glintColorWithAlpha);
        }
        poseStack.popPose();
    }
}

