/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.content;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import world.landfall.landfallessentials.block.custom.AsphaltBlock;
import world.landfall.landfallessentials.block.custom.BlueShonkBlock;
import world.landfall.landfallessentials.block.custom.PinkShonkBlock;
import world.landfall.landfallessentials.block.custom.SpookiestRockBlock;
import world.landfall.landfallessentials.item.custom.BlockItemWithLore;
import world.landfall.landfallessentials.item.custom.ConduitItem;
import world.landfall.landfallessentials.item.custom.ConduitType;
import world.landfall.landfallessentials.item.custom.CuddlyItem;
import world.landfall.landfallessentials.item.custom.NobleBloodBookItem;
import world.landfall.landfallessentials.registry.ModBlocks;
import world.landfall.landfallessentials.registry.ModItems;

public class RegisteredItems {
    public static final List<DeferredItem<Item>> ALL_ITEMS = new ArrayList<DeferredItem<Item>>();
    private static final FoodProperties COTSWOLD_FOOD = new FoodProperties.Builder().nutrition(4).saturationModifier(0.6f).build();
    private static final FoodProperties ICE_SOUP_FOOD = new FoodProperties.Builder().nutrition(6).saturationModifier(0.8f).usingConvertsTo((ItemLike)Items.BOWL).alwaysEdible().fast().build();
    private static final FoodProperties REDSHIFT_FOOD = new FoodProperties.Builder().nutrition(0).saturationModifier(0.0f).alwaysEdible().fast().effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 3000, 1, false, false), 1.0f).effect(() -> new MobEffectInstance(MobEffects.DIG_SPEED, 3000, 2, false, false), 1.0f).effect(() -> new MobEffectInstance(MobEffects.GLOWING, 3000, 0, false, false), 1.0f).build();
    private static final FoodProperties GLOWSTICK_FOOD = new FoodProperties.Builder().nutrition(0).saturationModifier(0.0f).alwaysEdible().fast().effect(() -> new MobEffectInstance(MobEffects.GLOWING, 600, 0, false, false), 1.0f).effect(() -> new MobEffectInstance(MobEffects.CONFUSION, 120, 0, false, false), 1.0f).effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 0, false, false), 1.0f).build();
    private static final FoodProperties GRIMROOT_FOOD = new FoodProperties.Builder().nutrition(0).saturationModifier(0.0f).alwaysEdible().fast().effect(() -> new MobEffectInstance(MobEffects.ABSORPTION, 6000, 0, false, false), 1.0f).effect(() -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 6000, 1, false, false), 1.0f).build();
    private static final FoodProperties VERDANCYX_FOOD = new FoodProperties.Builder().nutrition(0).saturationModifier(0.0f).alwaysEdible().fast().effect(() -> new MobEffectInstance(MobEffects.REGENERATION, 3000, 0, false, false), 1.0f).effect(() -> new MobEffectInstance(MobEffects.NIGHT_VISION, 3000, 0, false, false), 1.0f).effect(() -> new MobEffectInstance(MobEffects.SLOW_FALLING, 3000, 0, false, false), 1.0f).build();
    public static final DeferredItem<Item> COTSWOLD = RegisteredItems.registerFood("cotswold", COTSWOLD_FOOD, "A quaint item from the Cotswolds.");
    public static final DeferredItem<Item> VERDANCYX = RegisteredItems.registerFood("verdancyx", VERDANCYX_FOOD, "An experimental biotonic, cultivated from ancient growth and stabilized through refined crystals.", "The paper shimmers with a faint emerald glow.");
    public static final DeferredItem<Item> REDSHIFT = RegisteredItems.registerFood("redshift", REDSHIFT_FOOD, "A refined stimulant synthesized from Redstone saturation and rare catalytic fusion.", "The vibrant red substance pulses with unstable energy.");
    public static final DeferredItem<Item> ICE_SOUP = RegisteredItems.registerFood("ice_soup", ICE_SOUP_FOOD, "Surprisingly refreshing, or just cold?");
    public static final DeferredItem<Item> GRIMROOT = RegisteredItems.registerFood("grimroot", GRIMROOT_FOOD, "An unholy amalgamation of fungi farmed from soil soaked in death.", "The twisted roots emit a faint whisper when held.", "Those who consume it feel the earth's embrace, both protective and haunting.");
    public static final DeferredItem<Item> ASTOLFO_VOTIVE = RegisteredItems.register("astolfo_votive", "A small offering, full of hope.");
    public static final DeferredItem<Item> ENRICHED_REFINED_FUEL = RegisteredItems.register("enriched_refined_fuel", "Highly potent and volatile fuel. Can superheat blaze burners.");
    public static final DeferredItem<Item> RAW_HYDROCARBONS = RegisteredItems.register("raw_hydrocarbons", "Crude and unrefined, but full of potential.");
    public static final DeferredItem<Item> DISTILLED_HYDROCARBONS = RegisteredItems.register("distilled_hydrocarbons", "Purified for maximum efficiency.");
    public static final DeferredItem<Item> GLOWSTICK = RegisteredItems.registerFood("glowstick", GLOWSTICK_FOOD, "A little marking on the side says DaemonWare Labs.", "Another little marking says DO NOT CONSUME.", "Unfortunately, you're feeling a bit 'quirky' and 'cute'...");
    public static final DeferredItem<Item> RICKS_SCROLL = RegisteredItems.register("ricks_scroll", "Contains ancient, possibly dangerous, knowledge.");
    public static final DeferredItem<Item> LE_FISHE_AU_CHOCOLAT = RegisteredItems.register("le_fishe_au_chocolat", "A culinary... experience.");
    public static final DeferredItem<Item> REFINED_FUEL = RegisteredItems.register("refined_fuel", "Standard grade fuel for everyday machinery.");
    public static final DeferredItem<Item> MALT = RegisteredItems.register("malt", "Crops ground up fine allowing it to ferment quickly. The resulting brew isn't quality for consumption but can be turned to ethanol.");
    public static final DeferredItem<Item> BLANK_ENCHANTED_BOOK = RegisteredItems.register("blank_enchanted_book", "A tome capable of holding enchantments");
    public static final DeferredItem<Item> NOBLE_BLOOD_BOOK = ModItems.ITEMS.register("noble_blood_book", () -> new NobleBloodBookItem(new Item.Properties()));
    public static final DeferredItem<Item> EXTRACTED_GOLD_CLUMP;
    public static final DeferredItem<Item> EXTRACTED_COPPER_CLUMP;
    public static final DeferredItem<Item> EXTRACTED_QUARTZ_CLUMP;
    public static final DeferredItem<Item> EXTRACTED_EMERALD_CLUMP;
    public static final DeferredItem<Item> EXTRACTED_DIAMOND_CLUMP;
    public static final DeferredItem<Item> EXTRACTED_ZINC_CLUMP;
    public static final DeferredItem<Item> EXTRACTED_LAPIS_CLUMP;
    public static final DeferredItem<Item> EXTRACTED_ANCIENT_CLUMP;
    public static final DeferredItem<Item> CRUSHED_GOLD_CLUMP;
    public static final DeferredItem<Item> CRUSHED_COPPER_CLUMP;
    public static final DeferredItem<Item> CRUSHED_QUARTZ_CLUMP;
    public static final DeferredItem<Item> CRUSHED_EMERALD_CLUMP;
    public static final DeferredItem<Item> CRUSHED_DIAMOND_CLUMP;
    public static final DeferredItem<Item> CRUSHED_ZINC_CLUMP;
    public static final DeferredItem<Item> CRUSHED_LAPIS_CLUMP;
    public static final DeferredItem<Item> CRUSHED_ANCIENT_SHARDS;
    public static final DeferredBlock<AsphaltBlock> ASPHALT;
    public static final DeferredBlock<BlueShonkBlock> BLUE_SHONK;
    public static final DeferredBlock<PinkShonkBlock> PINK_SHONK;
    public static final DeferredBlock<SpookiestRockBlock> SPOOKIEST_ROCK;
    public static final DeferredItem<Item> CONTINUUM_CONDUIT;
    public static final DeferredItem<Item> DOMINION_CONDUIT;
    public static final DeferredItem<Item> REVELATION_CONDUIT;
    public static final DeferredItem<Item> ENTROPY_CONDUIT;
    public static final DeferredItem<Item> SILENCE_CONDUIT;

    private static DeferredItem<Item> register(String name, String ... lore) {
        DeferredItem<Item> item = ModItems.registerItemWithLore(name, lore);
        ALL_ITEMS.add(item);
        return item;
    }

    private static DeferredItem<Item> registerFood(String name, FoodProperties foodProperties, String ... lore) {
        DeferredItem<Item> item = ModItems.registerItemWithLore(name, new Item.Properties().food(foodProperties), lore);
        ALL_ITEMS.add(item);
        return item;
    }

    private static DeferredBlock<Block> registerBlock(String name, MapColor mapColor, String ... lore) {
        DeferredBlock<Block> block = ModBlocks.registerStoneBlock(name, mapColor);
        DeferredItem<BlockItem> blockItem = ModBlocks.registerBlockItem(name, block);
        ALL_ITEMS.add(blockItem);
        return block;
    }

    private static DeferredBlock<AsphaltBlock> registerAsphaltBlock(String name, MapColor mapColor, String ... lore) {
        DeferredBlock<AsphaltBlock> block = ModBlocks.registerCustomStoneBlock(name, () -> new AsphaltBlock(BlockBehaviour.Properties.of().mapColor(mapColor).strength(1.0f, 6.0f).sound(SoundType.STONE)));
        DeferredItem<BlockItem> blockItem = ModBlocks.registerBlockItem(name, block);
        ALL_ITEMS.add(blockItem);
        return block;
    }

    private static DeferredBlock<BlueShonkBlock> registerBlueShonkBlock(String name, MapColor mapColor, String ... lore) {
        DeferredBlock<BlueShonkBlock> block = ModBlocks.registerCustomBlock(name, () -> new BlueShonkBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).mapColor(mapColor).noOcclusion()));
        DeferredItem blockItem = ModItems.ITEMS.register(name, () -> new CuddlyItem((Block)block.get(), new Item.Properties()));
        ALL_ITEMS.add((DeferredItem<Item>)blockItem);
        return block;
    }

    private static DeferredBlock<PinkShonkBlock> registerPinkShonkBlock(String name, MapColor mapColor, String ... lore) {
        DeferredBlock<PinkShonkBlock> block = ModBlocks.registerCustomBlock(name, () -> new PinkShonkBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).mapColor(mapColor).noOcclusion()));
        DeferredItem blockItem = ModItems.ITEMS.register(name, () -> new CuddlyItem((Block)block.get(), new Item.Properties()));
        ALL_ITEMS.add((DeferredItem<Item>)blockItem);
        return block;
    }

    private static DeferredBlock<SpookiestRockBlock> registerSpookiestRockBlock(String name, MapColor mapColor, String ... lore) {
        DeferredBlock<SpookiestRockBlock> block = ModBlocks.registerCustomStoneBlock(name, () -> new SpookiestRockBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).mapColor(mapColor)));
        DeferredItem blockItem = ModItems.ITEMS.register(name, () -> new BlockItemWithLore((Block)block.get(), new Item.Properties(), lore));
        ALL_ITEMS.add((DeferredItem<Item>)blockItem);
        return block;
    }

    public static void init() {
    }

    static {
        ALL_ITEMS.add(NOBLE_BLOOD_BOOK);
        EXTRACTED_GOLD_CLUMP = RegisteredItems.register("extracted_gold_clump", "A rough clump of minerals with traces of metal, needs refined to be useful.");
        EXTRACTED_COPPER_CLUMP = RegisteredItems.register("extracted_copper_clump", "A rough clump of minerals with traces of metal, needs refined to be useful.");
        EXTRACTED_QUARTZ_CLUMP = RegisteredItems.register("extracted_quartz_clump", "A rough clump of minerals with traces of crystal, needs refined to be useful.");
        EXTRACTED_EMERALD_CLUMP = RegisteredItems.register("extracted_emerald_clump", "A rough clump of minerals with traces of gem, needs refined to be useful.");
        EXTRACTED_DIAMOND_CLUMP = RegisteredItems.register("extracted_diamond_clump", "A rough clump of minerals with traces of gem, needs refined to be useful.");
        EXTRACTED_ZINC_CLUMP = RegisteredItems.register("extracted_zinc_clump", "A rough clump of minerals with traces of metal, needs refined to be useful.");
        EXTRACTED_LAPIS_CLUMP = RegisteredItems.register("extracted_lapis_clump", "A rough clump of minerals with traces of gem, needs refined to be useful.");
        EXTRACTED_ANCIENT_CLUMP = RegisteredItems.register("extracted_ancient_clump", "A rough clump of minerals with traces of ancient shards, needs refined to be useful.");
        CRUSHED_GOLD_CLUMP = RegisteredItems.register("crushed_gold_clump", "Removed large impurties by crushing");
        CRUSHED_COPPER_CLUMP = RegisteredItems.register("crushed_copper_clump", "Removed large impurties by crushing");
        CRUSHED_QUARTZ_CLUMP = RegisteredItems.register("crushed_quartz_clump", "Removed large impurties by crushing");
        CRUSHED_EMERALD_CLUMP = RegisteredItems.register("crushed_emerald_clump", "Removed large impurties by crushing");
        CRUSHED_DIAMOND_CLUMP = RegisteredItems.register("crushed_diamond_clump", "Removed large impurties by crushing");
        CRUSHED_ZINC_CLUMP = RegisteredItems.register("crushed_zinc_clump", "Removed large impurties by crushing");
        CRUSHED_LAPIS_CLUMP = RegisteredItems.register("crushed_lapis_clump", "Removed large impurties by crushing");
        CRUSHED_ANCIENT_SHARDS = RegisteredItems.register("crushed_ancient_shards", "Shards of Ancient Debris");
        ASPHALT = RegisteredItems.registerAsphaltBlock("asphalt", MapColor.COLOR_BLACK, "Smooth road surface material that enhances movement speed.");
        BLUE_SHONK = RegisteredItems.registerBlueShonkBlock("shonk_blue", MapColor.COLOR_BLUE, "A cuddly blue shark plushie.", "Soft and squishy, perfect for decoration!");
        PINK_SHONK = RegisteredItems.registerPinkShonkBlock("shonk_pink", MapColor.COLOR_PINK, "A cuddly pink shark plushie.", "Soft and squishy, perfect for decoration!");
        SPOOKIEST_ROCK = RegisteredItems.registerSpookiestRockBlock("spookiest_rock", MapColor.STONE, "Just an ordinary rock...", "...or is it?", "Very scary...");
        CONTINUUM_CONDUIT = ModItems.ITEMS.register("continuum_conduit", () -> new ConduitItem(ConduitType.CONTINUUM, new Item.Properties(), "\u00a77A relic said to anchor the self across time. Those who hold it feel their wounds knit not just by flesh, but by the memory of the body.", "\u00a76Passive: \u00a7eRegeneration I", "\u00a76Active: \u00a7eInstant Health I (60s Cooldown)", "\u00a76In-Character (GM Ticket): \u00a7eThe bearer may open a ticket to get partial flashbacks or full recollection of events witnessed by past characters provided ample canon justification. Can additionally be used to \"undo\" amnesia due to head trauma or related injuries."));
        DOMINION_CONDUIT = ModItems.ITEMS.register("dominion_conduit", () -> new ConduitItem(ConduitType.DOMINION, new Item.Properties(), "\u00a77Forged in the ashes of the old wars, the Dominion Conduit was said to be used by Lilarreich to assert early power millennia ago.", "\u00a76Passive: \u00a7eResistance I and Strength I", "\u00a76Active: \u00a78None", "\u00a76In-Character (GM Ticket): \u00a78None"));
        REVELATION_CONDUIT = ModItems.ITEMS.register("revelation_conduit", () -> new ConduitItem(ConduitType.REVELATION, new Item.Properties(), "\u00a77An eye that never closes. Revelation pierces veil and shadow alike.", "\u00a76Passive: \u00a7eNight Vision", "\u00a76Active: \u00a78None", "\u00a76In-Character (GM Ticket): \u00a7eOn occasion, the bearer may \"see through\" illusions or uncover hidden writing provided IC justification. Useful for ARG elements or plot clues. Can be creatively extended to be a sort of \"seeing stone\" in a very limited capacity."));
        ENTROPY_CONDUIT = ModItems.ITEMS.register("entropy_conduit", () -> new ConduitItem(ConduitType.ENTROPY, new Item.Properties(), "\u00a77Entropy is not destruction, it is simply inevitability. Those who hold it move with uncanny rhythm, like systems unspooling in perfect chaos.", "\u00a76Passive: \u00a7eHaste I and Speed I", "\u00a76Active: \u00a78None", "\u00a76In-Character (GM Ticket): \u00a78None"));
        SILENCE_CONDUIT = ModItems.ITEMS.register("silence_conduit", () -> new ConduitItem(ConduitType.SILENCE, new Item.Properties(), "\u00a77The world turns loud with power, but silence is older. It does not shout, but it endures. Said to have once muted a battlefield and sealed a thousand secrets in its wake.", "\u00a76Passive: \u00a78None", "\u00a76Active: \u00a7eInvisibility I (60s Cooldown)", "\u00a76In-Character (GM Ticket): \u00a78None"));
        ALL_ITEMS.add(CONTINUUM_CONDUIT);
        ALL_ITEMS.add(DOMINION_CONDUIT);
        ALL_ITEMS.add(REVELATION_CONDUIT);
        ALL_ITEMS.add(ENTROPY_CONDUIT);
        ALL_ITEMS.add(SILENCE_CONDUIT);
    }
}

